/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.transfer;

import com.zutubi.pulse.transfer.JDBCTransferException;
import com.zutubi.pulse.transfer.MappingUtils;
import com.zutubi.pulse.transfer.TransferException;
import com.zutubi.pulse.transfer.TransferTarget;
import com.zutubi.pulse.upgrade.tasks.MutableConfiguration;
import com.zutubi.pulse.util.JDBCUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCTransferTarget
implements TransferTarget {
    private static final Logger LOG = Logger.getLogger(JDBCTransferTarget.class);
    private Table table;
    private Connection connection;
    private PreparedStatement insert;
    private String insertSql;
    private DataSource dataSource;
    private MutableConfiguration configuration;
    private boolean originalAutoCommitSetting = false;
    private int rowCount = 0;

    @Override
    public void start() throws TransferException {
        try {
            this.connection = this.dataSource.getConnection();
            this.createSchema(this.configuration);
            this.originalAutoCommitSetting = this.connection.getAutoCommit();
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw new JDBCTransferException(e);
        }
    }

    @Override
    public void startTable(Table table) throws TransferException {
        try {
            this.table = table;
            this.insertSql = MappingUtils.sqlInsert(table);
            LOG.info(this.insertSql);
            this.insert = this.connection.prepareStatement(this.insertSql);
        }
        catch (SQLException e) {
            throw new JDBCTransferException(e);
        }
    }

    @Override
    public void row(Map<String, Object> row) throws TransferException {
        try {
            List<Column> columns = MappingUtils.getColumns(this.table);
            LinkedList<Object> data = new LinkedList<Object>();
            for (int i = 0; i < columns.size(); ++i) {
                Object obj = row.get(columns.get(i).getName());
                data.add(obj);
                this.insert.setObject(i + 1, obj);
            }
            String sql = this.insertSql.replace("?", "%s");
            LOG.fine(String.format(sql, data.toArray()));
            this.insert.execute();
            if (++this.rowCount % 1000 == 0) {
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            throw new JDBCTransferException(e);
        }
    }

    @Override
    public void endTable() throws TransferException {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            throw new JDBCTransferException(e);
        }
        JDBCUtils.close((PreparedStatement)this.insert);
    }

    @Override
    public void end() throws TransferException {
        try {
            this.connection.setAutoCommit(this.originalAutoCommitSetting);
            this.createSchemaConstraints(this.configuration);
        }
        catch (SQLException e) {
            throw new JDBCTransferException(e);
        }
    }

    @Override
    public void close() {
        JDBCUtils.close((Connection)this.connection);
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setConfiguration(MutableConfiguration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSchema(MutableConfiguration configuration) throws SQLException, TransferException {
        Iterator tableMappings = configuration.getTableMappings();
        while (tableMappings.hasNext()) {
            Table table = (Table)tableMappings.next();
            if (!JDBCUtils.tableExists((Connection)this.connection, (String)table.getName())) continue;
            throw new TransferException("Unable to create the new database schema. The table '" + table.getName() + "' " + "already exists. Please ensure that you are importing into a blank database.");
        }
        Dialect dialect = Dialect.getDialect((Properties)configuration.getProperties());
        String[] sqlCreate = configuration.generateSchemaCreationScript(dialect);
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            for (String sql : sqlCreate) {
                if (!sql.startsWith("create")) continue;
                LOG.info(sql);
                stmt.executeUpdate(sql);
            }
        }
        finally {
            JDBCUtils.close((Statement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSchemaConstraints(MutableConfiguration configuration) throws SQLException {
        Dialect dialect = Dialect.getDialect((Properties)configuration.getProperties());
        String[] sqlAlter = configuration.generateSchemaCreationScript(dialect);
        Statement stmt = null;
        try {
            stmt = this.connection.createStatement();
            for (String sql : sqlAlter) {
                if (!sql.startsWith("alter")) continue;
                LOG.info(sql);
                stmt.executeUpdate(sql);
            }
        }
        finally {
            JDBCUtils.close((Statement)stmt);
        }
    }
}

