/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.servlet;

import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.core.model.StoredFileArtifact;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.util.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewFileServlet
extends HttpServlet {
    private BuildManager buildManager;
    private MasterConfigurationManager configurationManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        StoredFileArtifact fileArtifact;
        long artifactId;
        long resultId;
        String path;
        String[] parts;
        if (this.buildManager == null) {
            this.buildManager = (BuildManager)ComponentContext.getBean((String)"buildManager");
        }
        if (this.configurationManager == null) {
            this.configurationManager = (MasterConfigurationManager)ComponentContext.getBean((String)"configurationManager");
        }
        if ((parts = (path = httpServletRequest.getPathInfo()).split("/", 4)).length != 4) {
            httpServletResponse.sendError(404);
            return;
        }
        try {
            resultId = Long.parseLong(parts[1]);
            artifactId = Long.parseLong(parts[2]);
        }
        catch (NumberFormatException e) {
            httpServletResponse.sendError(404);
            return;
        }
        CommandResult result = this.buildManager.getCommandResult(resultId);
        if (result == null) {
            httpServletResponse.sendError(404);
            return;
        }
        StoredArtifact artifact = this.buildManager.getArtifact(artifactId);
        if (artifact == null) {
            httpServletResponse.sendError(404);
            return;
        }
        String filePath = parts[3];
        if (filePath.endsWith("/")) {
            filePath = filePath.substring(0, filePath.length() - 1);
        }
        File file = new File(result.getAbsoluteOutputDir(this.configurationManager.getDataDirectory()), filePath);
        if (filePath.equals(artifact.getName())) {
            if (!artifact.hasIndexFile()) {
                httpServletResponse.sendError(404);
                return;
            }
            String index = artifact.findIndexFile();
            filePath = filePath + "/" + index;
            file = new File(file, index);
        }
        if ((fileArtifact = artifact.findFile(filePath)) != null && fileArtifact.getType() != null) {
            httpServletResponse.setContentType(fileArtifact.getType());
        } else {
            httpServletResponse.setContentType(URLConnection.guessContentTypeFromName(filePath));
        }
        if (!file.isFile()) {
            httpServletResponse.sendError(404);
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            IOUtils.joinStreams((InputStream)fis, (OutputStream)httpServletResponse.getOutputStream());
        }
        catch (Throwable throwable) {
            IOUtils.close(fis);
            throw throwable;
        }
        IOUtils.close((Closeable)fis);
    }
}

