/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.servlet;

import com.zutubi.pulse.MasterBuildPaths;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.services.InvalidTokenException;
import com.zutubi.pulse.services.ServiceTokenManager;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DownloadPatchServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(DownloadPatchServlet.class);
    private MasterConfigurationManager configurationManager;
    private ServiceTokenManager serviceTokenManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String token = request.getParameter("token");
            try {
                this.getServiceTokenManager().validateToken(token);
            }
            catch (InvalidTokenException e) {
                response.sendError(403, "Invalid token");
                return;
            }
            long userId = Long.parseLong(request.getParameter("user"));
            long number = Long.parseLong(request.getParameter("number"));
            MasterBuildPaths paths = new MasterBuildPaths(this.getConfigurationManager());
            File patchFile = paths.getUserPatchFile(userId, number);
            try {
                response.setContentType("application/x-octet-stream");
                response.setContentLength((int)patchFile.length());
                FileInputStream input = null;
                try {
                    input = new FileInputStream(patchFile);
                    IOUtils.joinStreams((InputStream)input, (OutputStream)response.getOutputStream());
                }
                catch (Throwable throwable) {
                    IOUtils.close(input);
                    throw throwable;
                }
                IOUtils.close((Closeable)input);
                response.getOutputStream().flush();
            }
            catch (FileNotFoundException e) {
                LOG.warning((Throwable)e);
                response.sendError(404, "File not found: " + e.getMessage());
            }
            catch (IOException e) {
                LOG.warning((Throwable)e);
                response.sendError(500, "I/O error: " + e.getMessage());
            }
        }
        catch (NumberFormatException e) {
            try {
                response.sendError(500, "Invalid parameter");
            }
            catch (IOException e1) {
                LOG.warning((Throwable)e1);
            }
        }
        catch (IOException e) {
            LOG.warning((Throwable)e);
        }
    }

    public MasterConfigurationManager getConfigurationManager() {
        if (this.configurationManager == null) {
            this.configurationManager = (MasterConfigurationManager)ComponentContext.getBean((String)"configurationManager");
        }
        return this.configurationManager;
    }

    public ServiceTokenManager getServiceTokenManager() {
        if (this.serviceTokenManager == null) {
            this.serviceTokenManager = (ServiceTokenManager)ComponentContext.getBean((String)"serviceTokenManager");
        }
        return this.serviceTokenManager;
    }
}

