/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.servlet;

import com.zutubi.pulse.Version;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.bootstrap.ConfigurationManager;
import com.zutubi.pulse.bootstrap.SystemPaths;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DownloadPackageServlet
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger(DownloadPackageServlet.class);
    private SystemPaths systemPaths;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String packageName = request.getPathInfo();
            if (packageName == null || packageName.length() == 0) {
                response.sendError(400);
                return;
            }
            if (packageName.startsWith("/")) {
                packageName = packageName.substring(1);
            }
            File packageFile = DownloadPackageServlet.getPackageFile(this.getSystemPaths(), packageName);
            try {
                response.setContentType("application/x-octet-stream");
                response.setContentLength((int)packageFile.length());
                FileInputStream input = null;
                try {
                    input = new FileInputStream(packageFile);
                    IOUtils.joinStreams((InputStream)input, (OutputStream)response.getOutputStream());
                }
                catch (Throwable throwable) {
                    IOUtils.close(input);
                    throw throwable;
                }
                IOUtils.close((Closeable)input);
                response.getOutputStream().flush();
            }
            catch (FileNotFoundException e) {
                LOG.warning((Throwable)e);
                response.sendError(404, "File not found: " + e.getMessage());
            }
            catch (IOException e) {
                LOG.warning((Throwable)e);
                response.sendError(500, "I/O error: " + e.getMessage());
            }
        }
        catch (IOException e) {
            LOG.warning((Throwable)e);
        }
    }

    public static File getAgentZip(SystemPaths systemPaths) {
        return DownloadPackageServlet.getPackageFile(systemPaths, "pulse-agent-" + Version.getVersion().getVersionNumber() + ".zip");
    }

    public static File getPackageFile(SystemPaths systemPaths, String packageName) {
        return new File(DownloadPackageServlet.getPackageDir(systemPaths), packageName);
    }

    public static File getPackageDir(SystemPaths systemPaths) {
        return new File(systemPaths.getSystemRoot(), "packages");
    }

    private SystemPaths getSystemPaths() {
        if (this.systemPaths == null) {
            ConfigurationManager configurationManager = (ConfigurationManager)ComponentContext.getBean((String)"configurationManager");
            this.systemPaths = configurationManager.getSystemPaths();
        }
        return this.systemPaths;
    }

    public static String getPackagesUrl(String masterUrl) {
        return masterUrl + "/packages";
    }
}

