/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.security;

import com.zutubi.pulse.security.BasicAuthenticationDetails;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.UserDetails;

public class AcegiUtils {
    public static void loginAs(UserDetails targetUser) {
        UsernamePasswordAuthenticationToken targetUserRequest = new UsernamePasswordAuthenticationToken((Object)targetUser, (Object)targetUser.getPassword(), targetUser.getAuthorities());
        SecurityContextHolder.getContext().setAuthentication((Authentication)targetUserRequest);
    }

    public static void logout() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public static String getLoggedInUser() {
        Object principle;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && (principle = authentication.getPrincipal()) instanceof UserDetails) {
            return ((UserDetails)principle).getUsername();
        }
        return null;
    }

    public static boolean canLogout() {
        if (AcegiUtils.getLoggedInUser() != null) {
            Object details;
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            return authentication == null || (details = authentication.getDetails()) == null || !(details instanceof BasicAuthenticationDetails);
        }
        return false;
    }

    public static boolean userHasRole(String role) {
        Object principle;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && (principle = authentication.getPrincipal()) instanceof UserDetails) {
            UserDetails details = (UserDetails)principle;
            for (GrantedAuthority authority : details.getAuthorities()) {
                if (!authority.getAuthority().equals(role)) continue;
                return true;
            }
        }
        return false;
    }
}

