/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.search;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchQuery<T>
implements Serializable {
    private List<Criterion> criterion = new LinkedList<Criterion>();
    private List<Order> ordering = new LinkedList<Order>();
    private Projection projection;
    private Class target;
    private HibernateTemplate hibernateTemplate;
    private SessionFactory sessionFactory;
    private static final int NOT_SPECIFIED = -1;
    private int firstResult = -1;
    private int maxResults = -1;

    protected SearchQuery(Class target) {
        this.target = target;
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public SearchQuery add(Criterion expression) {
        this.criterion.add(expression);
        return this;
    }

    public SearchQuery add(Order order) {
        this.ordering.add(order);
        return this;
    }

    public SearchQuery setProjection(Projection projection) {
        this.projection = projection;
        return this;
    }

    public List<T> list() {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(SearchQuery.this.target);
                SearchQuery.this.configureQuery(criteria);
                return criteria.list();
            }
        });
    }

    public T uniqueResult() {
        return (T)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(SearchQuery.this.target);
                SearchQuery.this.configureQuery(criteria);
                return criteria.uniqueResult();
            }
        });
    }

    public int count() {
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(SearchQuery.this.target);
                for (Criterion c : SearchQuery.this.criterion) {
                    criteria.add(c);
                }
                criteria.setProjection(Projections.rowCount());
                return criteria.uniqueResult();
            }
        });
    }

    protected void configureQuery(Criteria criteria) {
        if (this.firstResult != -1) {
            criteria.setFirstResult(this.firstResult);
        }
        if (this.maxResults != -1) {
            criteria.setMaxResults(this.maxResults);
        }
        for (Criterion c : this.criterion) {
            criteria.add(c);
        }
        for (Order o : this.ordering) {
            criteria.addOrder(o);
        }
        if (this.projection != null) {
            criteria.setProjection(this.projection);
        }
        SessionFactoryUtils.applyTransactionTimeout((Criteria)criteria, (SessionFactory)this.sessionFactory);
    }

    protected HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    protected SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.hibernateTemplate = new HibernateTemplate(sessionFactory);
    }
}

