/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.search;

import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.model.Project;
import java.util.Collection;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildResultExpressions {
    public static Criterion projectEq(Project project) {
        return Expression.eq((String)"project", (Object)((Object)project));
    }

    public static Criterion projectEq(long projectId) {
        return Expression.eq((String)"project.id", (Object)projectId);
    }

    public static Criterion projectIn(Collection<Project> projects) {
        return Expression.in((String)"project", projects);
    }

    public static Criterion buildSpecEq(String buildSpec) {
        return Expression.eq((String)"buildSpecification", (Object)buildSpec);
    }

    public static Criterion statesIn(ResultState ... states) {
        Object[] stateNames = new String[states.length];
        for (int i = 0; i < states.length; ++i) {
            stateNames[i] = states[i].toString();
        }
        return Expression.in((String)"stateName", (Object[])stateNames);
    }

    public static Criterion buildResultCompleted() {
        return BuildResultExpressions.statesIn(ResultState.SUCCESS, ResultState.FAILURE, ResultState.ERROR);
    }

    public static Criterion startsAfter(long timestamp) {
        return Expression.ge((String)"stamps.startTime", (Object)timestamp);
    }

    public static Criterion startsBefore(long timestamp) {
        return Expression.le((String)"stamps.startTime", (Object)timestamp);
    }

    public static Criterion hasWorkDirectory(boolean b) {
        return Expression.eq((String)"hasWorkDir", (Object)b);
    }

    public static Order orderByDescEndDate() {
        return Order.desc((String)"stamps.endTime");
    }
}

