/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scheduling;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.NamedEntity;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.scheduling.Task;
import com.zutubi.pulse.scheduling.TriggerState;
import com.zutubi.pulse.scheduling.tasks.BuildProjectTask;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Trigger
extends Entity
implements NamedEntity {
    public static final String DEFAULT_GROUP = "default";
    private String name;
    private String group;
    private TriggerState state = TriggerState.NONE;
    private long triggerCount;
    private Date previousTriggerTime;
    private Map<Serializable, Serializable> dataMap;
    private Class<? extends Task> taskClass;
    private long projectId;

    public Trigger() {
    }

    public Trigger(String name) {
        this(name, DEFAULT_GROUP);
    }

    public Trigger(String name, String group) {
        this.name = name;
        this.group = group;
    }

    public abstract String getType();

    public abstract Trigger copy(Project var1, Project var2);

    protected void copyCommon(Trigger copy, Project oldProject, Project newProject) {
        copy.setProject(newProject.getId());
        copy.name = this.name.replace(oldProject.getName(), newProject.getName());
        copy.group = this.group.replace(oldProject.getName(), newProject.getName());
        copy.dataMap = new TreeMap<Serializable, Serializable>();
        for (Map.Entry<Serializable, Serializable> entry : this.dataMap.entrySet()) {
            Serializable key = entry.getKey();
            Serializable value = entry.getValue();
            if (this.taskClass == BuildProjectTask.class && key.equals("spec")) {
                BuildSpecification spec = oldProject.getBuildSpecification((Long)value);
                value = Long.valueOf(newProject.getBuildSpecification(spec.getName()).getId());
            }
            copy.dataMap.put(key, value);
        }
        copy.taskClass = this.taskClass;
    }

    public String getEditKey() {
        return this.getType();
    }

    public Map<Serializable, Serializable> getDataMap() {
        if (this.dataMap == null) {
            this.dataMap = new HashMap<Serializable, Serializable>();
        }
        return this.dataMap;
    }

    private void setDataMap(Map<Serializable, Serializable> map) {
        this.dataMap = map;
    }

    public TriggerState getState() {
        return this.state;
    }

    public void setState(TriggerState state) {
        this.state = state;
    }

    public long getTriggerCount() {
        return this.triggerCount;
    }

    private void setTriggerCount(long count) {
        this.triggerCount = count;
    }

    public void fire() {
        ++this.triggerCount;
        this.previousTriggerTime = Calendar.getInstance().getTime();
    }

    public Date getPreviousTriggerTime() {
        return this.previousTriggerTime;
    }

    private void setPreviousTriggerTime(Date time) {
        this.previousTriggerTime = time;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getGroup() {
        return this.group;
    }

    void setGroup(String group) {
        this.group = group;
    }

    private void setTriggerState(String str) {
        this.state = TriggerState.valueOf(str);
    }

    private String getTriggerState() {
        return this.state.toString();
    }

    public void setTaskClass(Class<? extends Task> task) {
        this.taskClass = task;
    }

    public Class<? extends Task> getTaskClass() {
        return this.taskClass;
    }

    public boolean isPaused() {
        return TriggerState.PAUSED == this.getState();
    }

    public boolean isActive() {
        return TriggerState.SCHEDULED == this.getState();
    }

    public boolean isScheduled() {
        return TriggerState.NONE != this.getState();
    }

    public long getProject() {
        return this.projectId;
    }

    public void setProject(long projectId) {
        this.projectId = projectId;
    }

    public boolean canEdit() {
        return false;
    }
}

