/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scheduling;

import com.zutubi.pulse.scheduling.QuartzTaskCallbackJob;
import com.zutubi.pulse.scheduling.SchedulerStrategy;
import com.zutubi.pulse.scheduling.SchedulingException;
import com.zutubi.pulse.scheduling.Trigger;
import com.zutubi.pulse.scheduling.TriggerHandler;
import com.zutubi.pulse.scheduling.TriggerState;
import com.zutubi.pulse.util.logging.Logger;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;

public abstract class QuartzSchedulerStrategy
implements SchedulerStrategy {
    private static final Logger LOG = Logger.getLogger(QuartzSchedulerStrategy.class);
    protected static final String CALLBACK_JOB_NAME = "cron.trigger.job.name";
    protected static final String CALLBACK_JOB_GROUP = "cron.trigger.job.group";
    protected static final String QUARTZ_GROUP = "DEFAULT";
    private Scheduler quartzScheduler;
    private TriggerHandler triggerHandler;

    public void setQuartzScheduler(Scheduler quartzScheduler) {
        this.quartzScheduler = quartzScheduler;
    }

    public Scheduler getQuartzScheduler() {
        return this.quartzScheduler;
    }

    public void pause(Trigger trigger) throws SchedulingException {
        try {
            this.getQuartzScheduler().pauseTrigger(Long.toString(trigger.getId()), QUARTZ_GROUP);
            trigger.setState(TriggerState.PAUSED);
        }
        catch (SchedulerException e) {
            throw new SchedulingException(e);
        }
    }

    public void resume(Trigger trigger) throws SchedulingException {
        try {
            this.getQuartzScheduler().resumeTrigger(Long.toString(trigger.getId()), QUARTZ_GROUP);
            trigger.setState(TriggerState.SCHEDULED);
        }
        catch (SchedulerException e) {
            throw new SchedulingException(e);
        }
    }

    public void stop(boolean force) {
        try {
            this.getQuartzScheduler().shutdown(!force);
        }
        catch (SchedulerException e) {
            LOG.severe("Unable to shutdown Quartz scheduler", (Throwable)e);
        }
    }

    public void unschedule(Trigger trigger) throws SchedulingException {
        try {
            this.getQuartzScheduler().unscheduleJob(Long.toString(trigger.getId()), QUARTZ_GROUP);
            trigger.setState(TriggerState.NONE);
        }
        catch (SchedulerException e) {
            throw new SchedulingException(e);
        }
    }

    protected void ensureCallbackRegistered() throws SchedulerException {
        JobDetail existingJob = this.getQuartzScheduler().getJobDetail(CALLBACK_JOB_NAME, CALLBACK_JOB_GROUP);
        if (existingJob == null) {
            JobDetail detail = new JobDetail(CALLBACK_JOB_NAME, CALLBACK_JOB_GROUP, QuartzTaskCallbackJob.class);
            detail.setDurability(true);
            this.getQuartzScheduler().addJob(detail, true);
        }
    }

    public void init(Trigger trigger) throws SchedulingException {
        boolean pause = trigger.isPaused();
        this.schedule(trigger);
        if (pause) {
            this.pause(trigger);
        }
    }

    public void schedule(Trigger trigger) throws SchedulingException {
        try {
            org.quartz.Trigger quartzTrigger = this.createTrigger(trigger);
            this.ensureCallbackRegistered();
            quartzTrigger.setJobName(CALLBACK_JOB_NAME);
            quartzTrigger.setJobGroup(CALLBACK_JOB_GROUP);
            quartzTrigger.getJobDataMap().put((Object)"trigger", (Object)trigger);
            this.getQuartzScheduler().scheduleJob(quartzTrigger);
            trigger.setState(TriggerState.SCHEDULED);
        }
        catch (SchedulerException e) {
            throw new SchedulingException(e);
        }
    }

    public void setTriggerHandler(TriggerHandler handler) {
        this.triggerHandler = handler;
    }

    public boolean dependsOnProject(Trigger trigger, long projectId) {
        return false;
    }

    protected abstract org.quartz.Trigger createTrigger(Trigger var1) throws SchedulingException;
}

