/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.scheduling;

import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.scheduling.EventTriggerFilter;
import com.zutubi.pulse.scheduling.Trigger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventTrigger
extends Trigger {
    static final String TYPE = "event";
    private static final Class<Event>[] DEFAULT_TRIGGER_EVENTS = new Class[]{Event.class};
    private Class<Event>[] triggers = DEFAULT_TRIGGER_EVENTS;
    private Class<? extends EventTriggerFilter> filterClass = null;

    public EventTrigger() {
    }

    @Override
    public EventTrigger copy(Project oldProject, Project newProject) {
        EventTrigger copy = new EventTrigger();
        this.copyCommon(copy, oldProject, newProject);
        copy.triggers = new Class[this.triggers.length];
        System.arraycopy(this.triggers, 0, copy.triggers, 0, this.triggers.length);
        copy.filterClass = this.filterClass;
        return copy;
    }

    public EventTrigger(Class<? extends Event> trigger) {
        this(trigger, null);
    }

    public EventTrigger(Class<? extends Event> trigger, String name) {
        this(trigger, name, "default");
    }

    public EventTrigger(Class<? extends Event> trigger, String name, Class<? extends EventTriggerFilter> filterClass) {
        this(trigger, name, "default");
        this.filterClass = filterClass;
    }

    public EventTrigger(Class<? extends Event> trigger, String name, String group) {
        super(name, group);
        this.triggers = new Class[]{trigger};
    }

    public EventTrigger(Class<? extends Event> trigger, String name, String group, Class<? extends EventTriggerFilter> filterClass) {
        super(name, group);
        this.triggers = new Class[]{trigger};
        this.filterClass = filterClass;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getEditKey() {
        String result = this.getType();
        for (Class<Event> c : this.triggers) {
            result = result + '.';
            result = result + c.getSimpleName();
        }
        return result;
    }

    public Class<Event>[] getTriggerEvents() {
        return this.triggers;
    }

    private Class getTriggerEvent() {
        return this.getTriggerEvents()[0];
    }

    private void setTriggerEvent(Class<? extends Event> event) {
        this.triggers = new Class[]{event};
    }

    public Class<? extends EventTriggerFilter> getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(Class<? extends EventTriggerFilter> filterClass) {
        this.filterClass = filterClass;
    }

    @Override
    public boolean canEdit() {
        return true;
    }
}

