/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.renderer;

import com.zutubi.pulse.bootstrap.SystemPaths;
import com.zutubi.pulse.committransformers.CommitMessageTransformerManager;
import com.zutubi.pulse.core.model.Changelist;
import com.zutubi.pulse.core.model.Feature;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.renderer.BuildResultRenderer;
import com.zutubi.pulse.renderer.TemplateInfo;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.StringUtils;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.project.CommitMessageSupport;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FreemarkerBuildResultRenderer
implements BuildResultRenderer {
    private static final Logger LOG = Logger.getLogger(FreemarkerBuildResultRenderer.class);
    private Configuration freemarkerConfiguration;
    private SystemPaths systemPaths;
    private CommitMessageTransformerManager commitMessageTransformerManager;

    @Override
    public void render(String baseUrl, BuildResult result, List<Changelist> changelists, String templateName, Writer writer) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("renderer", this);
        dataMap.put("baseUrl", baseUrl);
        dataMap.put("result", result);
        dataMap.put("changelists", changelists);
        dataMap.put("model", result);
        dataMap.put("errorLevel", Feature.Level.ERROR);
        dataMap.put("warningLevel", Feature.Level.WARNING);
        try {
            Template template = this.freemarkerConfiguration.getTemplate(this.getTemplatePath(result.isPersonal()) + File.separatorChar + templateName + ".ftl");
            template.process(dataMap, writer);
            writer.flush();
        }
        catch (Exception e) {
            LOG.warning("Unable to render build result: " + e.getMessage(), (Throwable)e);
        }
    }

    private String getTemplatePath(boolean personal) {
        return FileSystemUtils.composeFilename((String[])new String[]{"notifications", (personal ? "personal" : "project") + "-builds"});
    }

    @Override
    public List<TemplateInfo> getAvailableTemplates(boolean personal) {
        ArrayList<TemplateInfo> result = new ArrayList<TemplateInfo>();
        List templateRoots = this.systemPaths.getTemplateRoots();
        for (File root : templateRoots) {
            String[] names;
            File dir = new File(root, this.getTemplatePath(personal));
            if (!dir.isDirectory()) continue;
            for (String name : names = dir.list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".ftl");
                }
            })) {
                result.add(this.getTemplateInfo(name.substring(0, name.length() - 4), personal));
            }
        }
        return result;
    }

    @Override
    public TemplateInfo getTemplateInfo(String templateName, boolean personal) {
        String display = this.getDefaultDisplay(templateName);
        String mimeType = "text/plain";
        File propertiesFile = this.findProperties(templateName, personal);
        if (propertiesFile != null) {
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(propertiesFile));
                display = properties.getProperty("display", display);
                mimeType = properties.getProperty("type", mimeType);
            }
            catch (IOException e) {
                LOG.warning("Unable to load template properties file '" + propertiesFile.getAbsolutePath() + "'", (Throwable)e);
            }
        }
        return new TemplateInfo(templateName, display, mimeType);
    }

    public String getDefaultDisplay(String templateName) {
        return templateName.replaceAll("-", " ");
    }

    private File findProperties(String templateName, boolean personal) {
        List templateRoots = this.systemPaths.getTemplateRoots();
        for (File root : templateRoots) {
            File candidate;
            File dir = new File(root, this.getTemplatePath(personal));
            if (!dir.isDirectory() || !(candidate = new File(dir, templateName + ".properties")).exists()) continue;
            return candidate;
        }
        return null;
    }

    public String trimmedString(String s, int length) {
        return StringUtils.trimmedString((String)s, (int)length);
    }

    public String wrapString(String s, String prefix) {
        return StringUtils.wrapString((String)s, (int)64, (String)prefix);
    }

    public String transformComment(Changelist changelist) {
        CommitMessageSupport support = new CommitMessageSupport(changelist, this.commitMessageTransformerManager.getCommitMessageTransformers());
        return support.trim(60);
    }

    public void setFreemarkerConfiguration(Configuration freemarkerConfiguration) {
        this.freemarkerConfiguration = freemarkerConfiguration;
    }

    public void setCommitMessageTransformerManager(CommitMessageTransformerManager commitMessageTransformerManager) {
        this.commitMessageTransformerManager = commitMessageTransformerManager;
    }

    public void setSystemPaths(SystemPaths systemPaths) {
        this.systemPaths = systemPaths;
    }
}

