/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.plugins;

import com.zutubi.plugins.ComponentDescriptor;
import com.zutubi.plugins.ComponentDescriptorFactory;
import com.zutubi.plugins.ObjectFactory;
import com.zutubi.plugins.Plugin;
import com.zutubi.plugins.internal.DefaultComponentDescriptorFactory;
import com.zutubi.plugins.internal.loaders.ClassPathPluginLoader;
import com.zutubi.plugins.repositories.LocalPluginRepository;
import com.zutubi.pulse.plugins.PluginsObjectFactoryAdaptor;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PulsePluginManager {
    private LocalPluginRepository repository;
    private ClassPathPluginLoader classPathLoader;
    private Map<String, Class<? extends ComponentDescriptor>> descriptors = new HashMap<String, Class<? extends ComponentDescriptor>>();
    private List<String> systemPluginDescriptors = new LinkedList<String>();
    private File pluginDirectory = null;
    private List<Plugin> plugins;
    private com.zutubi.pulse.core.ObjectFactory objectFactory;

    public void setPluginDirectory(File dir) {
        this.pluginDirectory = dir;
    }

    public void setSystemPluginDescriptors(List<String> systemPluginDescriptors) {
        this.systemPluginDescriptors = systemPluginDescriptors;
    }

    public void setObjectFactory(com.zutubi.pulse.core.ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setDescriptors(Map<String, Class<? extends ComponentDescriptor>> descriptors) {
        this.descriptors = descriptors;
    }

    public void init() {
        DefaultComponentDescriptorFactory descriptorFactory = new DefaultComponentDescriptorFactory();
        descriptorFactory.setObjectFactory((ObjectFactory)new PluginsObjectFactoryAdaptor(this.objectFactory));
        descriptorFactory.setDescriptors(this.descriptors);
        this.plugins = new LinkedList<Plugin>();
        if (this.pluginDirectory != null) {
            this.repository = new LocalPluginRepository(this.pluginDirectory);
            this.repository.setDescriptorFactory((ComponentDescriptorFactory)descriptorFactory);
            this.repository.scanForPlugins();
            this.plugins.addAll(this.repository.getPlugins());
        }
        this.classPathLoader = new ClassPathPluginLoader();
        this.classPathLoader.setComponentDescriptorFactory((ComponentDescriptorFactory)descriptorFactory);
        for (String descriptor : this.systemPluginDescriptors) {
            this.classPathLoader.setDescriptor(descriptor);
            this.plugins.addAll(this.classPathLoader.loadPlugins());
        }
        for (Plugin plugin : this.plugins) {
            plugin.enable();
        }
    }

    public void install(Plugin plugin) {
        if (this.repository.containsPlugin(plugin)) {
            throw new IllegalArgumentException();
        }
        this.repository.installPlugin(plugin);
    }

    public List<Plugin> getPlugins() {
        return this.plugins;
    }

    public void destory() {
        if (this.repository != null) {
            this.repository.destory();
        }
        for (Plugin plugin : this.plugins) {
            plugin.close();
        }
    }

    public void uninstall(Plugin plugin) {
        if (!this.repository.containsPlugin(plugin)) {
            throw new IllegalArgumentException();
        }
        this.repository.uninstallPlugin(plugin);
    }
}

