/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model.persistence.mock;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.model.persistence.EntityDao;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MockEntityDao<T extends Entity>
implements EntityDao<T> {
    private long id = 1L;
    protected List<T> entities = new LinkedList<T>();

    @Override
    public void delete(T entity) {
        this.entities.remove(entity);
    }

    @Override
    public int count() {
        return this.entities.size();
    }

    @Override
    public List<T> findAll() {
        return new LinkedList<T>(this.entities);
    }

    @Override
    public T findById(long id) {
        for (Entity t : this.entities) {
            if (t.getId() != id) continue;
            return (T)t;
        }
        return null;
    }

    @Override
    public <U extends T> U findByIdAndType(long id, Class<U> type) {
        for (Entity t : this.entities) {
            if (t.getId() != id) continue;
            return (U)t;
        }
        return null;
    }

    @Override
    public void refresh(T entity) {
    }

    @Override
    public void save(T entity) {
        if (!this.entities.contains(entity)) {
            this.setId((Entity)entity, this.nextId());
            this.entities.add(entity);
        }
    }

    protected List<T> findByFilter(Filter<T> f) {
        LinkedList<Entity> findResults = new LinkedList<Entity>();
        for (Entity t : this.entities) {
            if (!f.include(t)) continue;
            findResults.add(t);
        }
        return findResults;
    }

    protected T findUniqueByFilter(Filter<T> f) {
        List<T> findResults = this.findByFilter(f);
        if (findResults.size() > 1) {
            throw new RuntimeException();
        }
        if (findResults.size() == 1) {
            return (T)((Entity)findResults.get(0));
        }
        return null;
    }

    private long nextId() {
        return this.id++;
    }

    private void setId(Entity entity, long id) {
        try {
            for (Class<?> cls = entity.getClass(); cls != null; cls = cls.getSuperclass()) {
                try {
                    Method m = cls.getDeclaredMethod("setId", Long.TYPE);
                    m.setAccessible(true);
                    m.invoke((Object)entity, id);
                    return;
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
            }
            throw new RuntimeException("setId not found.");
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface Filter<T> {
        public boolean include(T var1);
    }
}

