/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model.persistence.hibernate;

import com.zutubi.pulse.model.Group;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectGroup;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.persistence.UserDao;
import com.zutubi.pulse.model.persistence.hibernate.HibernateEntityDao;
import com.zutubi.pulse.util.logging.Logger;
import java.util.List;
import java.util.Set;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.type.Type;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateUserDao
extends HibernateEntityDao<User>
implements UserDao {
    private static final Logger LOG = Logger.getLogger(HibernateEntityDao.class);

    @Override
    public Class persistentClass() {
        return User.class;
    }

    @Override
    public User findByLogin(final String login) {
        List users = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from User user where user.login = :login");
                queryObject.setParameter("login", (Object)login, (Type)Hibernate.STRING);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateUserDao.this.getSessionFactory());
                queryObject.setCacheable(true);
                return queryObject.list();
            }
        });
        if (users.size() > 1) {
            LOG.warning("findByLogin has returned " + users.size() + " results when expecting at most one.");
        }
        if (users.size() > 0) {
            return (User)((Object)users.get(0));
        }
        return null;
    }

    @Override
    public List<User> findByLikeLogin(final String login) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from User user where user.login like :login");
                queryObject.setParameter("login", (Object)login, (Type)Hibernate.STRING);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateUserDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    @Override
    public Set<Project> getShownProjects(final User user) {
        User u = (User)((Object)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from User user left join fetch user.shownProjects where user.id = :id");
                queryObject.setParameter("id", (Object)user.getId());
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateUserDao.this.getSessionFactory());
                return queryObject.uniqueResult();
            }
        }));
        return u.getShownProjects();
    }

    @Override
    public List<User> findByNotInGroup(final Group group) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from User user where :group not in elements(user.groups)");
                queryObject.setEntity("group", (Object)group);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateUserDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    @Override
    public List<User> findByShownProject(final Project project) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from User user where :project in elements(user.shownProjects)");
                queryObject.setEntity("project", (Object)project);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateUserDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    @Override
    public List<User> findByShownProjectGroup(final ProjectGroup group) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from User user where :group in elements(user.shownGroups)");
                queryObject.setEntity("group", (Object)group);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateUserDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }
}

