/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model.persistence.hibernate;

import com.zutubi.pulse.model.persistence.ObjectHandle;
import com.zutubi.pulse.model.persistence.ObjectHandleResolver;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.entity.EntityLoader;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;

public class HibernateObjectHandleResolver
extends ObjectHandleResolver {
    private SessionImplementor session;
    private SessionFactoryImplementor factory;

    public Object resolve(ObjectHandle handle) {
        return this.session.immediateLoad(handle.clazz.getName(), handle.id);
    }

    public Object[] resolve(ObjectHandle[] handles) {
        if (handles.length == 0) {
            return new Object[0];
        }
        Serializable[] ids = this.extractIds(handles);
        Class persistentType = handles[0].clazz;
        ClassMetadata metaData = this.factory.getClassMetadata(persistentType);
        EntityPersister persister = this.factory.getEntityPersister(metaData.getEntityName());
        EntityLoader loader = new EntityLoader((OuterJoinLoadable)persister, handles.length, LockMode.READ, this.factory, Collections.EMPTY_MAP);
        List objects = loader.loadEntityBatch(this.session, ids, persister.getIdentifierType(), null, null, null, persister);
        return objects.toArray(new Object[objects.size()]);
    }

    private Serializable[] extractIds(ObjectHandle[] handles) {
        LinkedList<Serializable> ids = new LinkedList<Serializable>();
        for (int i = 0; i < handles.length; ++i) {
            ids.add(handles[i].id);
        }
        return ids.toArray(new Serializable[ids.size()]);
    }

    public void setSession(Session session) {
        this.session = (SessionImplementor)session;
    }

    public void setSessionFactory(SessionFactory factory) {
        this.factory = (SessionFactoryImplementor)factory;
    }
}

