/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model.persistence.hibernate;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.model.persistence.EntityDao;
import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Projections;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateObjectRetrievalFailureException;
import org.springframework.orm.hibernate3.SessionFactoryUtils;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HibernateEntityDao<T extends Entity>
extends HibernateDaoSupport
implements EntityDao<T> {
    @Override
    public T findById(long id) {
        return (T)this.findByIdAndType(id, this.persistentClass());
    }

    @Override
    public <U extends T> U findByIdAndType(long id, Class<U> type) {
        return (U)((Entity)this.findAnyType(id, type));
    }

    public Object findAnyType(long id, Class type) {
        try {
            return this.getHibernateTemplate().load(type, (Serializable)Long.valueOf(id));
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        catch (HibernateObjectRetrievalFailureException e) {
            return null;
        }
    }

    @Override
    public List<T> findAll() {
        return this.getHibernateTemplate().loadAll(this.persistentClass());
    }

    @Override
    public void save(T entity) {
        this.getHibernateTemplate().saveOrUpdate(entity);
    }

    @Override
    public void delete(T entity) {
        this.getHibernateTemplate().delete(entity);
    }

    @Override
    public void refresh(T entity) {
        this.getHibernateTemplate().refresh(entity);
    }

    @Override
    public int count() {
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(HibernateEntityDao.this.persistentClass());
                criteria.setProjection(Projections.rowCount());
                SessionFactoryUtils.applyTransactionTimeout((Criteria)criteria, (SessionFactory)HibernateEntityDao.this.getSessionFactory());
                return criteria.uniqueResult();
            }
        });
    }

    public Object findFirstByNamedQuery(String queryName) {
        return this.findFirstByNamedQuery(queryName, false);
    }

    public Object findFirstByNamedQuery(String queryName, boolean cachable) {
        return this.findFirstByNamedQuery(queryName, null, null, cachable);
    }

    public Object findFirstByNamedQuery(String queryName, String propertyName, Object propertyValue) {
        return this.findFirstByNamedQuery(queryName, propertyName, propertyValue, false);
    }

    public Object findFirstByNamedQuery(final String queryName, final String propertyName, final Object propertyValue, final boolean cacheable) {
        List results = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                if (propertyName != null) {
                    queryObject.setParameter(propertyName, propertyValue);
                }
                queryObject.setMaxResults(1);
                queryObject.setCacheable(cacheable);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateEntityDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
        if (results != null && results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    public <U> List<U> findByNamedQuery(String queryName) {
        return this.findByNamedQuery(queryName, 0);
    }

    public <U> List<U> findByNamedQuery(String queryName, int maxResults) {
        return this.findByNamedQuery(queryName, maxResults, false);
    }

    public <U> List<U> findByNamedQuery(String queryName, int maxResults, boolean cachable) {
        return this.findByNamedQuery(queryName, null, null, maxResults, cachable);
    }

    public <U> List<U> findByNamedQuery(String queryName, String propertyName, Object propertyValue) {
        return this.findByNamedQuery(queryName, propertyName, propertyValue, 0);
    }

    public <U> List<U> findByNamedQuery(String queryName, String propertyName, Object propertyValue, int maxResults) {
        return this.findByNamedQuery(queryName, propertyName, propertyValue, maxResults, false);
    }

    public <U> List<U> findByNamedQuery(final String queryName, final String propertyName, final Object propertyValue, final int maxResults, final boolean cachable) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                if (propertyName != null) {
                    queryObject.setParameter(propertyName, propertyValue);
                }
                if (maxResults > 0) {
                    queryObject.setMaxResults(maxResults);
                }
                queryObject.setCacheable(cachable);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateEntityDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    public final Object findUniqueByNamedQuery(String queryName) {
        return this.findUniqueByNamedQuery(queryName, false);
    }

    public final Object findUniqueByNamedQuery(String queryName, boolean cachable) {
        return this.findUniqueByNamedQuery(queryName, null, null, cachable);
    }

    public final Object findUniqueByNamedQuery(String queryName, String propertyName, Object propertyValue) {
        return this.findUniqueByNamedQuery(queryName, propertyName, propertyValue, false);
    }

    public final Object findUniqueByNamedQuery(String queryName, String propertyName, Object propertyValue, boolean cachable) {
        return this.findUniqueByNamedQuery(queryName, propertyName, propertyValue, null, null, cachable);
    }

    public final Object findUniqueByNamedQuery(String queryName, String propertyName, Object propertyValue, String secondPropertyName, Object secondPropertyValue) {
        return this.findUniqueByNamedQuery(queryName, propertyName, propertyValue, secondPropertyName, secondPropertyValue, false);
    }

    public final Object findUniqueByNamedQuery(final String queryName, final String propertyName, final Object propertyValue, final String secondPropertyName, final Object secondPropertyValue, final boolean cachable) {
        return this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.getNamedQuery(queryName);
                if (propertyName != null) {
                    queryObject.setParameter(propertyName, propertyValue);
                }
                if (secondPropertyName != null) {
                    queryObject.setParameter(secondPropertyName, secondPropertyValue);
                }
                queryObject.setCacheable(cachable);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateEntityDao.this.getSessionFactory());
                return queryObject.uniqueResult();
            }
        });
    }

    public abstract Class persistentClass();
}

