/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model.persistence.hibernate;

import com.zutubi.pulse.core.model.Changelist;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.persistence.ChangelistDao;
import com.zutubi.pulse.model.persistence.hibernate.HibernateEntityDao;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateChangelistDao
extends HibernateEntityDao<Changelist>
implements ChangelistDao {
    @Override
    public Class persistentClass() {
        return Changelist.class;
    }

    @Override
    public List<Changelist> findLatestByUser(final User user, final int max) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from Changelist model where model.revision.author in (:logins) order by model.revision.time desc");
                LinkedList<String> allLogins = new LinkedList<String>();
                allLogins.add(user.getLogin());
                allLogins.addAll(user.getAliases());
                queryObject.setParameterList("logins", allLogins);
                queryObject.setMaxResults(max);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateChangelistDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    @Override
    public List<Changelist> findLatestByProject(final Project project, final int max) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from Changelist model where :projectId in elements(model.projectIds) order by model.revision.time desc");
                queryObject.setParameter("projectId", (Object)project.getId());
                queryObject.setMaxResults(max);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateChangelistDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    @Override
    public List<Changelist> findLatestByProjects(Project[] projects, final int max) {
        List changelists;
        final Long[] projectIds = new Long[projects.length];
        for (int i = 0; i < projects.length; ++i) {
            projectIds[i] = projects[i].getId();
        }
        LinkedHashSet results = new LinkedHashSet();
        final int[] offset = new int[]{0};
        while (results.size() < max && (changelists = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from Changelist model join model.projectIds project where project in (:projectIds) order by model.revision.time desc");
                queryObject.setParameterList("projectIds", (Object[])projectIds);
                queryObject.setFirstResult(offset[0]);
                queryObject.setMaxResults(max);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateChangelistDao.this.getSessionFactory());
                return queryObject.list();
            }
        })).size() != 0) {
            results.addAll(changelists);
            offset[0] = offset[0] + max;
        }
        ArrayList<Changelist> changes = new ArrayList<Changelist>(results);
        while (changes.size() > max) {
            changes.remove(changes.size() - 1);
        }
        return changes;
    }

    @Override
    public Changelist findByRevision(final String serverUid, final Revision revision) {
        return (Changelist)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from Changelist model where model.serverUid = :serverUid and model.revision.revisionString = :revisionString");
                queryObject.setParameter("serverUid", (Object)serverUid);
                queryObject.setParameter("revisionString", (Object)revision.getRevisionString());
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateChangelistDao.this.getSessionFactory());
                return queryObject.uniqueResult();
            }
        });
    }

    @Override
    public List<Changelist> findByResult(final long id) {
        List all = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from Changelist model where :resultId in elements(model.resultIds) order by model.revision.time desc");
                queryObject.setParameter("resultId", (Object)id);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateChangelistDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
        LinkedHashSet<Changelist> set = new LinkedHashSet<Changelist>(all);
        for (Changelist changelist : all) {
            changelist.getChanges().size();
            set.add(changelist);
        }
        return new LinkedList<Changelist>(set);
    }
}

