/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model.persistence.hibernate;

import com.zutubi.pulse.model.BuildHostRequirements;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.BuildSpecificationNode;
import com.zutubi.pulse.model.BuildStage;
import com.zutubi.pulse.model.Slave;
import com.zutubi.pulse.model.SlaveBuildHostRequirements;
import com.zutubi.pulse.model.persistence.BuildSpecificationDao;
import com.zutubi.pulse.model.persistence.hibernate.HibernateEntityDao;
import com.zutubi.pulse.util.Predicate;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateBuildSpecificationDao
extends HibernateEntityDao<BuildSpecification>
implements BuildSpecificationDao {
    @Override
    public Class persistentClass() {
        return BuildSpecification.class;
    }

    @Override
    public List<BuildSpecification> findBySlave(final Slave slave) {
        List all = this.findAll();
        LinkedList<BuildSpecification> referringToSlave = new LinkedList<BuildSpecification>();
        LinkedList<BuildSpecificationNode> nodes = new LinkedList<BuildSpecificationNode>();
        for (BuildSpecification spec : all) {
            spec.getRoot().getNodesByPredicate(new Predicate<BuildSpecificationNode>(){

                public boolean satisfied(BuildSpecificationNode node) {
                    BuildHostRequirements hostRequirements;
                    BuildStage stage = node.getStage();
                    if (stage != null && (hostRequirements = stage.getHostRequirements()) instanceof SlaveBuildHostRequirements) {
                        return ((SlaveBuildHostRequirements)hostRequirements).getSlave().getId() == slave.getId();
                    }
                    return false;
                }
            }, nodes);
            if (nodes.isEmpty()) continue;
            nodes.clear();
            referringToSlave.add(spec);
        }
        return referringToSlave;
    }

    @Override
    public void delete(BuildHostRequirements hostRequirements) {
        this.getHibernateTemplate().delete((Object)hostRequirements);
    }
}

