/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model.persistence.hibernate;

import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.PersistentName;
import com.zutubi.pulse.core.model.RecipeResult;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.core.model.StoredFileArtifact;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.persistence.BuildResultDao;
import com.zutubi.pulse.model.persistence.hibernate.HibernateEntityDao;
import com.zutubi.pulse.util.logging.Logger;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.type.Type;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.SessionFactoryUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateBuildResultDao
extends HibernateEntityDao<BuildResult>
implements BuildResultDao {
    private static final Logger LOG = Logger.getLogger(HibernateEntityDao.class);
    private static final String SPEC_QUERY = "select distinct model.specName from BuildResult model";

    @Override
    public Class persistentClass() {
        return BuildResult.class;
    }

    @Override
    public List<BuildResult> findLatestByProject(Project project, int max) {
        return this.findLatestByProject(project, 0, max);
    }

    @Override
    public List<BuildResult> findSinceByProject(final Project project, final PersistentName spec, final Date since) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from BuildResult model where model.project = :project and model.specName = :spec and model.user = null and model.stamps.endTime > :since order by model.number desc");
                queryObject.setEntity("project", (Object)project);
                queryObject.setEntity("spec", (Object)spec);
                queryObject.setLong("since", since.getTime());
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateBuildResultDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    @Override
    public List<BuildResult> findLatestByProject(final Project project, final int first, final int max) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from BuildResult model where model.project = :project and model.user = null order by model.number desc");
                queryObject.setEntity("project", (Object)project);
                queryObject.setFirstResult(first);
                queryObject.setMaxResults(max);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateBuildResultDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    @Override
    public BuildResult findPreviousBuildResult(final BuildResult result) {
        return (BuildResult)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from BuildResult model where model.user = null and model.project = :project and model.number < :number order by model.number desc");
                queryObject.setEntity("project", (Object)result.getProject());
                queryObject.setLong("number", result.getNumber());
                queryObject.setMaxResults(1);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateBuildResultDao.this.getSessionFactory());
                return queryObject.uniqueResult();
            }
        });
    }

    @Override
    public List<BuildResult> findLatestCompleted(final Project project, final PersistentName spec, final int first, final int max) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = HibernateBuildResultDao.this.getBuildResultCriteria(session, project, ResultState.getCompletedStates(), spec, false);
                criteria.setFirstResult(first);
                criteria.setMaxResults(max);
                criteria.addOrder(Order.desc((String)"number"));
                SessionFactoryUtils.applyTransactionTimeout((Criteria)criteria, (SessionFactory)HibernateBuildResultDao.this.getSessionFactory());
                return criteria.list();
            }
        });
    }

    @Override
    public List<BuildResult> findLatestByProject(final Project project, final ResultState[] states, final PersistentName spec, final int first, final int max) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = HibernateBuildResultDao.this.getBuildResultCriteria(session, project, states, spec, false);
                criteria.setFirstResult(first);
                criteria.setMaxResults(max);
                criteria.addOrder(Order.desc((String)"id"));
                return criteria.list();
            }
        });
    }

    @Override
    public List<BuildResult> findOldestByProject(final Project project, final ResultState[] states, final int max, final boolean includePersonal) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = HibernateBuildResultDao.this.getBuildResultCriteria(session, project, states, null, includePersonal);
                criteria.setMaxResults(max);
                criteria.addOrder(Order.asc((String)"id"));
                return criteria.list();
            }
        });
    }

    @Override
    public BuildResult findByProjectAndNumber(final Project project, final long number) {
        List results = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query queryObject = session.createQuery("from BuildResult model where model.user = null and model.project = :project and model.number = :number");
                queryObject.setEntity("project", (Object)project);
                queryObject.setParameter("number", (Object)number, (Type)Hibernate.LONG);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateBuildResultDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
        if (results.size() > 1) {
            LOG.warning("findByProjectNameAndNumber has returned " + results.size() + " results when expecting at most one.");
        }
        if (results.size() > 0) {
            return (BuildResult)results.get(0);
        }
        return null;
    }

    @Override
    public BuildResult findByUserAndNumber(final User user, final long number) {
        List results = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query queryObject = session.createQuery("from BuildResult model where model.user = :user and model.number = :number");
                queryObject.setEntity("user", (Object)user);
                queryObject.setParameter("number", (Object)number, (Type)Hibernate.LONG);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateBuildResultDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
        if (results.size() > 1) {
            LOG.warning("findByUserAndNumber has returned " + results.size() + " results when expecting at most one.");
        }
        if (results.size() > 0) {
            return (BuildResult)results.get(0);
        }
        return null;
    }

    @Override
    public CommandResult findCommandResult(long id) {
        return (CommandResult)this.findAnyType(id, CommandResult.class);
    }

    @Override
    public RecipeResultNode findRecipeResultNode(long id) {
        return (RecipeResultNode)((Object)this.findAnyType(id, RecipeResultNode.class));
    }

    @Override
    public RecipeResult findRecipeResult(long id) {
        return (RecipeResult)this.findAnyType(id, RecipeResult.class);
    }

    @Override
    public int getBuildCount(final Project project, final ResultState[] states, final PersistentName spec) {
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = HibernateBuildResultDao.this.getBuildResultCriteria(session, project, states, spec, false);
                criteria.setProjection(Projections.rowCount());
                return criteria.uniqueResult();
            }
        });
    }

    @Override
    public int getBuildCount(final Project project, final ResultState[] states, final Boolean hasWorkDir) {
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = HibernateBuildResultDao.this.getBuildResultCriteria(session, project, states, null, false);
                if (hasWorkDir != null) {
                    criteria.add((Criterion)Expression.eq((String)"hasWorkDir", (Object)hasWorkDir));
                }
                criteria.setProjection(Projections.rowCount());
                return criteria.uniqueResult();
            }
        });
    }

    @Override
    public List<PersistentName> findAllSpecifications(final Project project) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("select distinct model.specName from BuildResult model where model.project = :project");
                queryObject.setEntity("project", (Object)project);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateBuildResultDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    @Override
    public List<PersistentName> findAllSpecificationsForProjects(final Project[] projects) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject;
                if (projects == null) {
                    queryObject = session.createQuery(HibernateBuildResultDao.SPEC_QUERY);
                } else {
                    queryObject = session.createQuery("select distinct model.specName from BuildResult model where model.project in (:projects)");
                    queryObject.setParameterList("projects", (Object[])projects);
                }
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateBuildResultDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    @Override
    public List<BuildResult> queryBuilds(final Project[] projects, final ResultState[] states, final PersistentName[] specs, final long earliestStartTime, final long latestStartTime, final Boolean hasWorkDir, final int first, final int max, final boolean mostRecentFirst) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(BuildResult.class);
                criteria.add(Expression.isNull((String)"user"));
                HibernateBuildResultDao.this.addProjectsToCriteria(projects, criteria);
                HibernateBuildResultDao.this.addStatesToCriteria(states, criteria);
                HibernateBuildResultDao.this.addSpecsToCriteria(specs, criteria);
                HibernateBuildResultDao.this.addDatesToCriteria(earliestStartTime, latestStartTime, criteria);
                if (hasWorkDir != null) {
                    criteria.add((Criterion)Expression.eq((String)"hasWorkDir", (Object)hasWorkDir));
                }
                if (first >= 0) {
                    criteria.setFirstResult(first);
                }
                if (max >= 0) {
                    criteria.setMaxResults(max);
                }
                if (mostRecentFirst) {
                    criteria.addOrder(Order.desc((String)"number"));
                } else {
                    criteria.addOrder(Order.asc((String)"number"));
                }
                return criteria.list();
            }
        });
    }

    @Override
    public List<BuildResult> querySpecificationBuilds(final Project project, final PersistentName spec, final ResultState[] states, final long lowestNumber, final long highestNumber, final int first, final int max, final boolean mostRecentFirst, boolean initialise) {
        List results = (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(BuildResult.class);
                criteria.add(Expression.isNull((String)"user"));
                criteria.add((Criterion)Expression.eq((String)"project", (Object)((Object)project)));
                criteria.add((Criterion)Expression.eq((String)"specName", (Object)spec));
                HibernateBuildResultDao.this.addStatesToCriteria(states, criteria);
                HibernateBuildResultDao.this.addNumbersToCriteria(lowestNumber, highestNumber, criteria);
                if (first >= 0) {
                    criteria.setFirstResult(first);
                }
                if (max >= 0) {
                    criteria.setMaxResults(max);
                }
                if (mostRecentFirst) {
                    criteria.addOrder(Order.desc((String)"number"));
                } else {
                    criteria.addOrder(Order.asc((String)"number"));
                }
                return criteria.list();
            }
        });
        if (initialise) {
            for (BuildResult result : results) {
                this.intialise(result);
            }
        }
        return results;
    }

    @Override
    public List<BuildResult> findByUser(User user) {
        return this.getLatestByUser(user, null, -1);
    }

    @Override
    public List<BuildResult> getLatestByUser(final User user, final ResultState[] states, final int max) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Criteria criteria = session.createCriteria(BuildResult.class);
                criteria.add((Criterion)Expression.eq((String)"user", (Object)((Object)user)));
                if (states != null) {
                    criteria.add(Expression.in((String)"stateName", (Object[])HibernateBuildResultDao.this.getStateNames(states)));
                }
                if (max > 0) {
                    criteria.setMaxResults(max);
                }
                criteria.addOrder(Order.desc((String)"number"));
                return criteria.list();
            }
        });
    }

    @Override
    public int getCompletedResultCount(final User user) {
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("select count (*) from BuildResult model where model.user = :user and model.stateName in (:stateNames)");
                queryObject.setEntity("user", (Object)user);
                queryObject.setParameterList("stateNames", (Object[])ResultState.getCompletedStateNames());
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateBuildResultDao.this.getSessionFactory());
                return queryObject.uniqueResult();
            }
        });
    }

    @Override
    public List<BuildResult> getOldestCompletedBuilds(final User user, final int max) {
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from BuildResult model where model.user = :user and model.stateName in (:stateNames) order by model.number asc");
                queryObject.setEntity("user", (Object)user);
                queryObject.setParameterList("stateNames", (Object[])ResultState.getCompletedStateNames());
                if (max > 0) {
                    queryObject.setMaxResults(max);
                }
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateBuildResultDao.this.getSessionFactory());
                return queryObject.list();
            }
        });
    }

    @Override
    public RecipeResultNode findResultNodeByResultId(long id) {
        return (RecipeResultNode)((Object)this.findUniqueByNamedQuery("findResultNodeByResultId", "id", id, true));
    }

    @Override
    public BuildResult findLatest() {
        return (BuildResult)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("from BuildResult result order by result.stamps.endTime desc");
                queryObject.setMaxResults(1);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateBuildResultDao.this.getSessionFactory());
                return queryObject.uniqueResult();
            }
        });
    }

    @Override
    public CommandResult findCommandResultByArtifact(final long artifactId) {
        return (CommandResult)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Query queryObject = session.createQuery("SELECT result FROM CommandResult result JOIN result.artifacts artifact WHERE artifact.id = :id");
                queryObject.setLong("id", artifactId);
                queryObject.setMaxResults(1);
                SessionFactoryUtils.applyTransactionTimeout((Query)queryObject, (SessionFactory)HibernateBuildResultDao.this.getSessionFactory());
                return queryObject.uniqueResult();
            }
        });
    }

    @Override
    public BuildResult findLatestByBuildSpec(BuildSpecification spec) {
        return (BuildResult)this.findFirstByNamedQuery("findLatestByBuildSpec", "name", spec.getPname(), false);
    }

    @Override
    public BuildResult findLatestSuccessfulBySpecification(BuildSpecification spec) {
        return (BuildResult)this.findFirstByNamedQuery("findLatestSuccessfulBySpecification", "specName", spec.getPname(), false);
    }

    @Override
    public BuildResult findLatestSuccessfulByProject(Project project) {
        return (BuildResult)this.findFirstByNamedQuery("findLatestSuccessfulByProject", "project", (Object)project, false);
    }

    @Override
    public BuildResult findLatestSuccessful() {
        return (BuildResult)this.findFirstByNamedQuery("findLatestSuccessful", false);
    }

    private void intialise(BuildResult result) {
        Hibernate.initialize((Object)result.getFeatures());
        for (RecipeResultNode node : result) {
            RecipeResult recipe = node.getResult();
            Hibernate.initialize((Object)recipe.getFeatures());
            for (CommandResult command : recipe.getCommandResults()) {
                Hibernate.initialize((Object)command.getFeatures());
                for (StoredArtifact artifact : command.getArtifacts()) {
                    for (StoredFileArtifact file : artifact.getChildren()) {
                        Hibernate.initialize((Object)file.getFeatures());
                    }
                }
            }
        }
    }

    private Criteria getBuildResultCriteria(Session session, Project project, ResultState[] states, PersistentName spec, boolean includePersonal) {
        Criteria criteria = session.createCriteria(BuildResult.class);
        if (!includePersonal) {
            criteria.add(Expression.isNull((String)"user"));
        }
        criteria.add((Criterion)Expression.eq((String)"project", (Object)((Object)project)));
        this.addStatesToCriteria(states, criteria);
        if (spec != null) {
            criteria.add((Criterion)Expression.eq((String)"specName", (Object)spec));
        }
        SessionFactoryUtils.applyTransactionTimeout((Criteria)criteria, (SessionFactory)this.getSessionFactory());
        return criteria;
    }

    private void addProjectsToCriteria(Project[] projects, Criteria criteria) {
        if (projects != null) {
            criteria.add(Expression.in((String)"project", (Object[])projects));
        }
    }

    private void addStatesToCriteria(ResultState[] states, Criteria criteria) {
        if (states != null) {
            criteria.add(Expression.in((String)"stateName", (Object[])this.getStateNames(states)));
        }
    }

    private String[] getStateNames(ResultState[] states) {
        String[] stateNames = new String[states.length];
        for (int i = 0; i < states.length; ++i) {
            stateNames[i] = states[i].toString();
        }
        return stateNames;
    }

    private void addSpecsToCriteria(PersistentName[] specs, Criteria criteria) {
        if (specs != null) {
            criteria.add(Expression.in((String)"specName", (Object[])specs));
        }
    }

    private void addDatesToCriteria(long earliestStartTime, long latestStartTime, Criteria criteria) {
        if (earliestStartTime > 0L) {
            criteria.add((Criterion)Expression.ge((String)"stamps.startTime", (Object)earliestStartTime));
        }
        if (latestStartTime > 0L) {
            criteria.add((Criterion)Expression.ge((String)"stamps.startTime", (Object)0L));
            criteria.add((Criterion)Expression.le((String)"stamps.startTime", (Object)latestStartTime));
        }
    }

    private void addNumbersToCriteria(long lowestNumber, long highestNumber, Criteria criteria) {
        if (lowestNumber > 0L) {
            criteria.add((Criterion)Expression.ge((String)"number", (Object)lowestNumber));
        }
        if (highestNumber > 0L) {
            criteria.add((Criterion)Expression.le((String)"number", (Object)highestNumber));
        }
    }

    @Override
    public void save(RecipeResultNode node) {
        this.getHibernateTemplate().saveOrUpdate((Object)node);
    }

    @Override
    public void save(PersistentName name) {
        this.getHibernateTemplate().saveOrUpdate((Object)name);
    }

    @Override
    public void save(RecipeResult result) {
        this.getHibernateTemplate().saveOrUpdate((Object)result);
    }

    @Override
    public void save(CommandResult result) {
        this.getHibernateTemplate().saveOrUpdate((Object)result);
    }
}

