/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model.persistence.hibernate;

import com.zutubi.pulse.model.persistence.AnyTypeDao;
import com.zutubi.pulse.model.persistence.ObjectHandle;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.EntityMode;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateAnyTypeDao
extends HibernateDaoSupport
implements AnyTypeDao {
    @Override
    public void save(Object entity) {
        this.getHibernateTemplate().saveOrUpdate(entity);
    }

    @Override
    public List<ObjectHandle> findAll() {
        LinkedList<ObjectHandle> handles = new LinkedList<ObjectHandle>();
        SessionFactoryImplementor factory = this.getSessionFactoryImplementor();
        for (ClassMetadata metaData : factory.getAllClassMetadata().values()) {
            handles.addAll(this.loadHandles(metaData));
        }
        return handles;
    }

    @Override
    public List<ObjectHandle> findAll(Class persistentClass) {
        SessionFactoryImplementor factory = this.getSessionFactoryImplementor();
        ClassMetadata metaData = factory.getClassMetadata(persistentClass);
        return this.loadHandles(metaData);
    }

    private List<ObjectHandle> loadHandles(ClassMetadata metaData) {
        LinkedList<ObjectHandle> handles = new LinkedList<ObjectHandle>();
        if (metaData.hasIdentifierProperty()) {
            String propertyName = metaData.getIdentifierPropertyName();
            Class clazz = metaData.getMappedClass(EntityMode.POJO);
            List ids = this.getSession().createCriteria(clazz).setProjection((Projection)Projections.property((String)propertyName)).list();
            for (Object id : ids) {
                handles.add(new ObjectHandle((Serializable)id, clazz));
            }
        }
        return handles;
    }

    private SessionFactoryImplementor getSessionFactoryImplementor() {
        return (SessionFactoryImplementor)this.getSessionFactory();
    }
}

