/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.model.CvsRevision;
import com.zutubi.pulse.core.model.FileRevision;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.model.BasePathChangeViewer;
import com.zutubi.pulse.model.ChangeViewer;
import com.zutubi.pulse.model.Scm;
import com.zutubi.pulse.util.StringUtils;

public class ViewVCChangeViewer
extends BasePathChangeViewer {
    private ViewVCChangeViewer() {
        super(null, null);
    }

    public ViewVCChangeViewer(String baseURL, String projectPath) {
        super(baseURL, projectPath);
    }

    public boolean hasCapability(Scm scm, ChangeViewer.Capability capability) {
        if (capability.equals((Object)ChangeViewer.Capability.VIEW_CHANGESET) && scm.getType().equals("cvs")) {
            return false;
        }
        return super.hasCapability(scm, capability);
    }

    public String getDetails() {
        return "ViewVC [" + this.getBaseURL() + "]";
    }

    public String getChangesetURL(Revision revision) {
        if (revision instanceof CvsRevision) {
            return null;
        }
        return StringUtils.join((String)"/", (boolean)true, (boolean)true, (String[])new String[]{this.getBaseURL(), this.getProjectPath() + "?rev=" + revision.getRevisionString() + "&view=rev"});
    }

    public String getFileViewURL(String path, FileRevision revision) {
        return StringUtils.join((String)"/", (boolean)true, (boolean)true, (String[])new String[]{this.getBaseURL(), this.getProjectPath(), path + "?rev=" + revision.getRevisionString() + "&view=markup"});
    }

    public String getFileDownloadURL(String path, FileRevision revision) {
        return StringUtils.join((String)"/", (boolean)true, (boolean)true, (String[])new String[]{this.getBaseURL(), "*checkout*", this.getProjectPath(), path + "?rev=" + revision.getRevisionString()});
    }

    public String getFileDiffURL(String path, FileRevision revision) {
        FileRevision previous = revision.getPrevious();
        if (previous == null) {
            return null;
        }
        return StringUtils.join((String)"/", (boolean)true, (boolean)true, (String[])new String[]{this.getBaseURL(), this.getProjectPath(), path + "?r1=" + previous.getRevisionString() + "&r2=" + revision.getRevisionString()});
    }

    public ChangeViewer copy() {
        return new ViewVCChangeViewer(this.getBaseURL(), this.getProjectPath());
    }
}

