/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.PulseFileDetails;
import com.zutubi.pulse.model.Scm;
import com.zutubi.pulse.personal.PatchArchive;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.util.FileSystemUtils;
import java.io.IOException;
import java.util.Properties;

public class VersionedPulseFileDetails
extends PulseFileDetails {
    private String pulseFileName;

    public VersionedPulseFileDetails() {
    }

    public VersionedPulseFileDetails(String pulseFileName) {
        this.pulseFileName = pulseFileName;
    }

    public VersionedPulseFileDetails copy() {
        return new VersionedPulseFileDetails(this.pulseFileName);
    }

    public boolean isBuiltIn() {
        return false;
    }

    public String getType() {
        return "versioned";
    }

    public Properties getProperties() {
        Properties result = new Properties();
        result.put("pulse file", this.pulseFileName);
        return result;
    }

    public String getPulseFile(long id, Project project, Revision revision, PatchArchive patch) {
        String normalisedPath = FileSystemUtils.normaliseSeparators((String)this.pulseFileName);
        if (patch == null || !patch.containsPath(normalisedPath)) {
            Scm scm = project.getScm();
            try {
                return scm.createServer().checkout(revision, this.pulseFileName);
            }
            catch (SCMException e) {
                throw new BuildException("Unable to retrieve pulse file from SCM: " + e.getMessage());
            }
        }
        try {
            return patch.retrieveFile(normalisedPath);
        }
        catch (IOException e) {
            throw new BuildException("Unable to retrieve pulse file from patch: " + e.getMessage());
        }
    }

    public String getPulseFileName() {
        return this.pulseFileName;
    }

    public void setPulseFileName(String pulseFileName) {
        this.pulseFileName = pulseFileName;
    }
}

