/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.model.Capture;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.PulseFileDetails;
import com.zutubi.pulse.personal.PatchArchive;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TemplatePulseFileDetails
extends PulseFileDetails {
    private static final Logger LOG = Logger.getLogger(TemplatePulseFileDetails.class);
    private List<Capture> captures = new LinkedList<Capture>();
    private List<String> outputProcessors = new LinkedList<String>();
    private VelocityEngine velocityEngine;

    protected void copyCommon(TemplatePulseFileDetails copy) {
        copy.captures = new LinkedList<Capture>();
        for (Capture c : this.captures) {
            copy.captures.add(c.copy());
        }
        copy.outputProcessors = new LinkedList<String>(this.outputProcessors);
    }

    @Override
    public boolean isBuiltIn() {
        return true;
    }

    @Override
    public String getPulseFile(long id, Project project, Revision revision, PatchArchive patch) {
        try {
            VelocityContext context = new VelocityContext();
            this.populateContext(context);
            this.addPostProcessors(context);
            context.put("details", (Object)this);
            context.put("outputProcessors", this.outputProcessors);
            context.put("captures", this.captures);
            StringWriter stringWriter = new StringWriter(1024);
            this.getVelocityEngine().mergeTemplate("pulse-file" + File.separatorChar + this.getTemplateName(), (Context)context, (Writer)stringWriter);
            return stringWriter.getBuffer().toString();
        }
        catch (Exception e) {
            LOG.warning((Throwable)e);
            throw new BuildException("Loading template pulse file: " + e.getMessage(), (Throwable)e);
        }
    }

    private void addPostProcessors(VelocityContext context) {
        TreeSet<String> includedProcessors = new TreeSet<String>();
        LinkedList<String> templates = new LinkedList<String>();
        for (String processor : this.outputProcessors) {
            this.addProcessor(includedProcessors, processor, templates);
        }
        for (Capture capture : this.captures) {
            for (String processor : capture.getProcessors()) {
                this.addProcessor(includedProcessors, processor, templates);
            }
        }
        context.put("postProcessorTemplates", templates);
    }

    private void addProcessor(Set<String> includedProcessors, String processor, List<String> templates) {
        if (!includedProcessors.contains(processor)) {
            includedProcessors.add(processor);
            templates.add(FileSystemUtils.composeFilename((String[])new String[]{"pulse-file", "post-processors", processor + ".vm"}));
        }
    }

    public List<Capture> getCaptures() {
        return this.captures;
    }

    private void setCaptures(List<Capture> captures) {
        this.captures = captures;
    }

    public Capture getCapture(String name) {
        for (Capture capture : this.captures) {
            if (!capture.getName().equals(name)) continue;
            return capture;
        }
        return null;
    }

    public Capture getCapture(long id) {
        for (Capture c : this.captures) {
            if (c.getId() != id) continue;
            return c;
        }
        return null;
    }

    public void addCapture(Capture capture) {
        this.captures.add(capture);
    }

    public void removeCapture(Capture capture) {
        this.captures.remove((Object)capture);
    }

    public boolean removeCapture(String name) {
        Capture deadMan = null;
        for (Capture c : this.captures) {
            if (!c.getName().equals(name)) continue;
            deadMan = c;
        }
        if (deadMan != null) {
            this.captures.remove((Object)deadMan);
            return true;
        }
        return false;
    }

    public List<String> getOutputProcessors() {
        return this.outputProcessors;
    }

    private void setOutputProcessors(List<String> outputProcessors) {
        this.outputProcessors = outputProcessors;
    }

    public VelocityEngine getVelocityEngine() {
        if (this.velocityEngine == null) {
            this.velocityEngine = (VelocityEngine)ComponentContext.getBean((String)"velocityEngine");
        }
        return this.velocityEngine;
    }

    public void setVelocityEngine(VelocityEngine velocityEngine) {
        this.velocityEngine = velocityEngine;
    }

    public String getReference(String name) {
        return "${" + name + "}";
    }

    protected abstract String getTemplateName();

    protected abstract void populateContext(VelocityContext var1);
}

