/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import antlr.collections.AST;
import com.zutubi.pulse.condition.FalseNotifyCondition;
import com.zutubi.pulse.condition.NotifyCondition;
import com.zutubi.pulse.condition.NotifyConditionFactory;
import com.zutubi.pulse.condition.TrueNotifyCondition;
import com.zutubi.pulse.condition.antlr.NotifyConditionLexer;
import com.zutubi.pulse.condition.antlr.NotifyConditionParser;
import com.zutubi.pulse.condition.antlr.NotifyConditionTreeParser;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.ContactPoint;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.Subscription;
import com.zutubi.pulse.util.logging.Logger;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectBuildSubscription
extends Subscription {
    private static final Logger LOG = Logger.getLogger(ProjectBuildSubscription.class);
    private String condition;
    private List<Project> projects = new LinkedList<Project>();
    private NotifyCondition notifyCondition = null;
    private NotifyConditionFactory notifyFactory;

    public ProjectBuildSubscription() {
    }

    public ProjectBuildSubscription(ContactPoint contactPoint, String template, String condition) {
        super(contactPoint, template);
        this.condition = condition;
    }

    public ProjectBuildSubscription(ContactPoint contactPoint, String template, List<Project> projects, String condition) {
        this(contactPoint, template, condition);
        this.projects = projects;
    }

    public List<Project> getProjects() {
        return this.projects;
    }

    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    @Override
    public boolean conditionSatisfied(BuildResult result) {
        return !result.isPersonal() && this.getNotifyCondition().satisfied(result, this.getContactPoint().getUser());
    }

    public NotifyCondition getNotifyCondition() {
        if (this.notifyCondition == null) {
            try {
                NotifyConditionLexer lexer = new NotifyConditionLexer(new StringReader(this.condition));
                NotifyConditionParser parser = new NotifyConditionParser(lexer);
                parser.orexpression();
                AST t = parser.getAST();
                if (t == null) {
                    this.notifyCondition = new TrueNotifyCondition();
                } else {
                    NotifyConditionTreeParser tree = new NotifyConditionTreeParser();
                    tree.setNotifyConditionFactory(this.notifyFactory);
                    this.notifyCondition = tree.cond(t);
                }
            }
            catch (Exception e) {
                LOG.severe("Unable to parse subscription condition '" + this.condition + "'");
                this.notifyCondition = new FalseNotifyCondition();
            }
        }
        return this.notifyCondition;
    }

    public void setNotifyConditionFactory(NotifyConditionFactory notifyFactory) {
        this.notifyFactory = notifyFactory;
    }
}

