/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.model.Resource;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.core.model.ResourceVersion;
import com.zutubi.pulse.model.Slave;

public class PersistentResource
extends Resource {
    private Slave slave;

    public PersistentResource() {
    }

    public PersistentResource(String name) {
        super(name);
    }

    public PersistentResource(String name, Slave slave) {
        super(name);
        this.slave = slave;
    }

    public PersistentResource(Resource resource, Slave slave) {
        this.setName(resource.getName());
        this.setProperties(resource.getProperties());
        this.setDefaultVersion(resource.getDefaultVersion());
        this.setVersions(resource.getVersions());
        this.slave = slave;
    }

    public Resource asResource() {
        Resource resource = new Resource(this.getName());
        for (ResourceProperty p : this.getProperties().values()) {
            resource.addProperty(new ResourceProperty(p.getName(), p.getValue(), p.getAddToEnvironment(), p.getAddToPath(), p.getResolveVariables()));
        }
        for (ResourceVersion v : this.getVersions().values()) {
            ResourceVersion copy = new ResourceVersion(v.getValue());
            for (ResourceProperty p : v.getProperties().values()) {
                try {
                    copy.addProperty(new ResourceProperty(p.getName(), p.getValue(), p.getAddToEnvironment(), p.getAddToPath(), p.getResolveVariables()));
                }
                catch (FileLoadException e) {}
            }
            resource.add(copy);
        }
        return resource;
    }

    public Slave getSlave() {
        return this.slave;
    }

    public void setSlave(Slave slave) {
        this.slave = slave;
    }
}

