/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.jabber.JabberManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.ContactPoint;
import com.zutubi.pulse.model.NotificationException;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.validation.annotations.Required;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.XMPPConnection;

public class JabberContactPoint
extends ContactPoint {
    private static final Logger LOG = Logger.getLogger(JabberContactPoint.class);
    private static final String NO_SERVER_ERROR = "Unable to send Jabber notification: Jabber server not configured.";
    private static final String NO_CONNECTION_ERROR = "Unable to send Jabber notification: not connected to Jabber server.";
    private JabberManager jabberManager;

    public String getDefaultTemplate() {
        return "simple-instant-message";
    }

    public void internalNotify(BuildResult result, String rendered, String mimeType) throws Exception {
        ComponentContext.autowire((Object)((Object)this));
        if (!this.jabberManager.isConfigured()) {
            LOG.warning(NO_SERVER_ERROR);
            throw new NotificationException(NO_SERVER_ERROR);
        }
        XMPPConnection connection = this.jabberManager.getConnection();
        if (connection != null) {
            try {
                Chat chat = connection.createChat(this.getUsername());
                chat.sendMessage(rendered);
            }
            catch (Exception e) {
                String message = "Unable to send jabber notification: " + e.getMessage();
                this.jabberManager.connectionError(message);
                LOG.warning(message, (Throwable)e);
                throw e;
            }
        } else {
            LOG.warning(NO_CONNECTION_ERROR);
            throw new NotificationException(NO_CONNECTION_ERROR);
        }
    }

    @Required
    public String getUsername() {
        return this.getUid();
    }

    public void setUsername(String username) {
        this.setUid(username);
    }

    public void setJabberManager(JabberManager jabberManager) {
        this.jabberManager = jabberManager;
    }
}

