/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.model.GrantedAuthority;
import com.zutubi.pulse.model.NamedEntity;
import com.zutubi.pulse.model.User;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends Entity
implements NamedEntity {
    private static final String DEFAULT_AUTHORITY_PREFIX = "GROUP_";
    private String name;
    private boolean adminAllProjects = false;
    private List<String> additionalAuthorities = new ArrayList<String>(2);
    private Set<User> users = new HashSet<User>();

    public Group() {
    }

    public Group(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getAuthorityCount() {
        return this.additionalAuthorities.size() + 1;
    }

    public List<GrantedAuthority> getAuthorities() {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>(this.additionalAuthorities.size() + 1);
        authorities.add(new GrantedAuthority(this.getDefaultAuthority()));
        for (String authority : this.additionalAuthorities) {
            authorities.add(new GrantedAuthority(authority));
        }
        return authorities;
    }

    public String getDefaultAuthority() {
        return DEFAULT_AUTHORITY_PREFIX + Long.toString(this.getId());
    }

    public boolean getAdminAllProjects() {
        return this.adminAllProjects;
    }

    public void setAdminAllProjects(boolean adminAllProjects) {
        this.adminAllProjects = adminAllProjects;
    }

    private List<String> getAdditionalAuthorities() {
        return this.additionalAuthorities;
    }

    private void setAdditionalAuthorities(List<String> additionalAuthorities) {
        this.additionalAuthorities = additionalAuthorities;
    }

    public void addAdditionalAuthority(String authority) {
        this.additionalAuthorities.add(authority);
    }

    public void removeAdditionalAuthority(String authority) {
        this.additionalAuthorities.remove(authority);
    }

    public boolean hasAuthority(String authority) {
        return authority.equals(this.getDefaultAuthority()) || this.additionalAuthorities.contains(authority);
    }

    public Set<User> getUsers() {
        return this.users;
    }

    private void setUsers(Set<User> users) {
        this.users = users;
    }

    public void addUser(User user) {
        this.users.add(user);
        user.addGroup(this);
    }

    public void removeUser(User user) {
        if (this.users.remove((Object)user)) {
            user.removeGroup(this);
        }
    }
}

