/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.model.TemplatePulseFileDetails;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.velocity.VelocityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutablePulseFileDetails
extends TemplatePulseFileDetails {
    private String executable;
    private String arguments;
    private String workingDir;
    private Map<String, String> environment = new TreeMap<String, String>();

    public ExecutablePulseFileDetails() {
    }

    public ExecutablePulseFileDetails(String executable, String arguments, String workingDir, Map<String, String> environment) {
        this.executable = executable;
        this.arguments = arguments;
        this.workingDir = workingDir;
        if (environment != null) {
            this.environment.putAll(environment);
        }
    }

    @Override
    public ExecutablePulseFileDetails copy() {
        TreeMap<String, String> env = new TreeMap<String, String>(this.environment);
        ExecutablePulseFileDetails copy = new ExecutablePulseFileDetails(this.executable, this.arguments, this.workingDir, env);
        this.copyCommon(copy);
        return copy;
    }

    @Override
    protected String getTemplateName() {
        return "executable.template.vm";
    }

    @Override
    protected void populateContext(VelocityContext context) {
        if (TextUtils.stringSet((String)this.executable)) {
            context.put("executable", (Object)this.executable);
        }
        if (TextUtils.stringSet((String)this.arguments)) {
            context.put("arguments", (Object)this.arguments);
        }
        if (TextUtils.stringSet((String)this.workingDir)) {
            context.put("workingDir", (Object)this.workingDir);
        }
        context.put("environment", this.environment);
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public void addEnvironmentalVariable(String name, String value) {
        this.environment.put(name, value);
    }

    @Override
    public String getType() {
        return "executable";
    }

    @Override
    public Properties getProperties() {
        String env;
        Properties result = new Properties();
        if (TextUtils.stringSet((String)this.executable)) {
            result.put("executable", this.executable);
        }
        if (TextUtils.stringSet((String)this.arguments)) {
            result.put("arguments", this.arguments);
        }
        if (TextUtils.stringSet((String)this.workingDir)) {
            result.put("working directory", this.workingDir);
        }
        if (TextUtils.stringSet((String)(env = this.getEnvironmentString()))) {
            result.put("environment", env);
        }
        return result;
    }

    private String getEnvironmentString() {
        StringBuilder result = new StringBuilder();
        String sep = "";
        for (Map.Entry<String, String> entry : this.environment.entrySet()) {
            result.append(sep);
            result.append((Object)entry.getKey());
            result.append('=');
            result.append((Object)entry.getValue());
            sep = "; ";
        }
        return result.toString();
    }
}

