/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.model.TestCaseIndex;
import com.zutubi.pulse.core.model.TestCaseResult;
import com.zutubi.pulse.core.model.TestHandler;
import com.zutubi.pulse.core.model.TestSuitePersister;
import com.zutubi.pulse.core.model.TestSuiteResult;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.model.TestManager;
import com.zutubi.pulse.model.persistence.TestCaseIndexDao;
import com.zutubi.pulse.util.StringUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import nu.xom.Attribute;
import nu.xom.Element;
import org.hibernate.SessionFactory;

public class DefaultTestManager
implements TestManager {
    private static final Logger LOG = Logger.getLogger(DefaultTestManager.class);
    private TestSuitePersister persister = new TestSuitePersister();
    private TestCaseIndexDao testCaseIndexDao;
    private MasterConfigurationManager configurationManager;
    private SessionFactory sessionFactory;

    public void index(BuildResult result) {
        if (!result.isPersonal()) {
            for (RecipeResultNode node : result) {
                File testDir = new File(node.getResult().getAbsoluteOutputDir(this.configurationManager.getDataDirectory()), "tests");
                if (!testDir.isDirectory()) continue;
                this.indexTestsForStage(result, result.getSpecName().getId(), node.getStageName().getId(), testDir);
            }
        }
    }

    private void indexTestsForStage(BuildResult result, long specNameId, long stageNameId, File testDir) {
        try {
            this.persister.read((TestHandler)new IndexingHandler(result.getProject().getId(), result.getId(), result.getNumber(), specNameId, stageNameId), null, testDir, true, false);
        }
        catch (Exception e) {
            LOG.severe("Unable to index test results for build: " + result.getNumber() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public void setTestCaseIndexDao(TestCaseIndexDao testCaseIndexDao) {
        this.testCaseIndexDao = testCaseIndexDao;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    private class IndexingHandler
    implements TestHandler {
        private Stack<TestSuiteResult> suites = new Stack();
        private Stack<Boolean> changed = new Stack();
        private long projectId;
        private long buildId;
        private long buildNumber;
        private long specNameId;
        private long stageNameId;
        private String path;
        private Map<String, TestCaseIndex> allCases;
        private int count = 0;

        public IndexingHandler(long projectId, long buildId, long buildNumber, long specNameId, long stageNameId) {
            this.projectId = projectId;
            this.buildId = buildId;
            this.buildNumber = buildNumber;
            this.specNameId = specNameId;
            this.stageNameId = stageNameId;
            List<TestCaseIndex> cases = DefaultTestManager.this.testCaseIndexDao.findByStage(stageNameId);
            this.allCases = new HashMap<String, TestCaseIndex>(cases.size());
            for (TestCaseIndex i : cases) {
                this.allCases.put(i.getName(), i);
            }
        }

        public void startSuite(TestSuiteResult suiteResult) {
            this.suites.push(suiteResult);
            this.changed.push(false);
            this.calculatePath();
        }

        public boolean endSuite() {
            this.suites.pop();
            this.calculatePath();
            return this.changed.pop();
        }

        private void calculatePath() {
            int i = 0;
            this.path = "";
            for (TestSuiteResult suite : this.suites) {
                if (i > 1) {
                    this.path = this.path + '/';
                }
                if (i > 0) {
                    this.path = this.path + StringUtils.urlEncode((String)suite.getName());
                }
                ++i;
            }
        }

        private String getCasePath(String name) {
            name = StringUtils.urlEncode((String)name);
            if (TextUtils.stringSet((String)this.path)) {
                return this.path + "/" + name;
            }
            return name;
        }

        public void handleCase(TestCaseResult caseResult, Element element) {
            String casePath = this.getCasePath(caseResult.getName());
            TestCaseIndex caseIndex = this.allCases.get(casePath);
            if (caseIndex == null) {
                caseIndex = new TestCaseIndex(this.projectId, this.specNameId, this.stageNameId, casePath);
            }
            if (caseResult.hasBrokenTests() && !caseIndex.isHealthy()) {
                element.addAttribute(new Attribute("broken-since", Long.toString(caseIndex.getBrokenSince())));
                element.addAttribute(new Attribute("broken-number", Long.toString(caseIndex.getBrokenNumber())));
                this.markChanged();
            } else if (!caseIndex.isHealthy() && caseResult.getStatus() == TestCaseResult.Status.PASS) {
                element.addAttribute(new Attribute("fixed", "true"));
                this.markChanged();
            }
            caseIndex.recordExecution(caseResult.getStatus(), this.buildId, this.buildNumber);
            if (++this.count % 1000 == 0) {
                DefaultTestManager.this.sessionFactory.getCurrentSession().flush();
            }
        }

        private void markChanged() {
            if (!this.changed.peek().booleanValue()) {
                this.changed.pop();
                this.changed.push(true);
            }
        }
    }
}

