/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.ConfigurableResourceRepository;
import com.zutubi.pulse.core.model.Resource;
import com.zutubi.pulse.core.model.ResourceVersion;
import com.zutubi.pulse.model.BuildSpecificationNode;
import com.zutubi.pulse.model.DatabaseResourceRepository;
import com.zutubi.pulse.model.PersistentResource;
import com.zutubi.pulse.model.ResourceManager;
import com.zutubi.pulse.model.ResourceRequirement;
import com.zutubi.pulse.model.Slave;
import com.zutubi.pulse.model.persistence.BuildSpecificationNodeDao;
import com.zutubi.pulse.model.persistence.ResourceDao;
import com.zutubi.pulse.resources.ResourceDiscoverer;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourceManager
implements ResourceManager {
    private ResourceDao resourceDao;
    private BuildSpecificationNodeDao buildSpecificationNodeDao;
    private DatabaseResourceRepository masterResourceRepository;
    private Map<Long, DatabaseResourceRepository> slaveRepositories = new TreeMap<Long, DatabaseResourceRepository>();

    public void init() {
        this.masterResourceRepository = new DatabaseResourceRepository(this.resourceDao);
        ResourceDiscoverer discoverer = new ResourceDiscoverer();
        List resources = discoverer.discover();
        this.addDiscoveredResources(null, resources);
    }

    @Override
    public void save(PersistentResource entity) {
        this.resourceDao.save(entity);
    }

    @Override
    public void delete(PersistentResource entity) {
        Slave slave = entity.getSlave();
        if (slave != null) {
            slave.getResources().remove((Object)entity);
        }
        this.resourceDao.delete(entity);
    }

    @Override
    public PersistentResource findById(long id) {
        return (PersistentResource)((Object)this.resourceDao.findById(id));
    }

    @Override
    public PersistentResource findBySlaveAndName(Slave slave, String name) {
        return this.resourceDao.findBySlaveAndName(slave, name);
    }

    @Override
    public DatabaseResourceRepository getMasterRepository() {
        return this.masterResourceRepository;
    }

    @Override
    public DatabaseResourceRepository getSlaveRepository(Slave slave) {
        if (!this.slaveRepositories.containsKey(slave.getId())) {
            this.slaveRepositories.put(slave.getId(), new DatabaseResourceRepository(slave, this.resourceDao));
        }
        return this.slaveRepositories.get(slave.getId());
    }

    @Override
    public void addDiscoveredResources(Slave slave, List<Resource> resources) {
        ConfigurableResourceRepository repository = this.getRepository(slave);
        for (Resource r : resources) {
            if (repository.hasResource(r.getName())) continue;
            repository.addResource(r);
        }
    }

    @Override
    public List<PersistentResource> findAll() {
        return this.resourceDao.findAll();
    }

    @Override
    public void editResource(PersistentResource resource, String newName, String defaultVersion) {
        List<BuildSpecificationNode> nodes = this.buildSpecificationNodeDao.findByResourceRequirement(resource.getName());
        for (BuildSpecificationNode node : nodes) {
            for (ResourceRequirement r : node.getResourceRequirements()) {
                if (!r.getResource().equals(resource.getName())) continue;
                r.setResource(newName);
            }
            this.buildSpecificationNodeDao.save(node);
        }
        resource.setName(newName);
        resource.setDefaultVersion(defaultVersion);
        this.resourceDao.save(resource);
    }

    @Override
    public void renameResourceVersion(PersistentResource resource, String value, String newValue) {
        List<BuildSpecificationNode> nodes = this.buildSpecificationNodeDao.findByResourceRequirement(resource.getName());
        for (BuildSpecificationNode node : nodes) {
            for (ResourceRequirement r : node.getResourceRequirements()) {
                if (!r.getResource().equals(resource.getName()) || !value.equals(r.getVersion())) continue;
                r.setVersion(newValue);
            }
            this.buildSpecificationNodeDao.save(node);
        }
        ResourceVersion version = resource.getVersion(value);
        resource.deleteVersion(version);
        version.setValue(newValue);
        resource.add(version);
        this.resourceDao.save(resource);
    }

    @Override
    public void addResource(Slave slave, Resource resource) {
        ConfigurableResourceRepository repository = this.getRepository(slave);
        repository.addResource(resource, true);
    }

    @Override
    public List<PersistentResource> findBySlave(Slave slave) {
        return this.resourceDao.findAllBySlave(slave);
    }

    public ConfigurableResourceRepository getRepository(Slave slave) {
        if (slave == null) {
            return this.getMasterRepository();
        }
        return this.getSlaveRepository(slave);
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.resourceDao = resourceDao;
    }

    public void setBuildSpecificationNodeDao(BuildSpecificationNodeDao buildSpecificationNodeDao) {
        this.buildSpecificationNodeDao = buildSpecificationNodeDao;
    }
}

