/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.cache.ehcache.CustomAclEntryCache;
import com.zutubi.pulse.core.BuildException;
import com.zutubi.pulse.core.BuildRevision;
import com.zutubi.pulse.core.PulseException;
import com.zutubi.pulse.core.PulseRuntimeException;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.core.model.TestCaseIndex;
import com.zutubi.pulse.events.Event;
import com.zutubi.pulse.events.EventManager;
import com.zutubi.pulse.events.build.BuildRequestEvent;
import com.zutubi.pulse.events.build.PersonalBuildRequestEvent;
import com.zutubi.pulse.license.LicenseException;
import com.zutubi.pulse.license.LicenseHolder;
import com.zutubi.pulse.license.LicenseManager;
import com.zutubi.pulse.license.authorisation.AddProjectAuthorisation;
import com.zutubi.pulse.model.AnyCapableBuildHostRequirements;
import com.zutubi.pulse.model.BuildHostRequirements;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildReason;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.BuildSpecificationNode;
import com.zutubi.pulse.model.BuildStage;
import com.zutubi.pulse.model.Capture;
import com.zutubi.pulse.model.ChangelistIsolator;
import com.zutubi.pulse.model.CleanupRule;
import com.zutubi.pulse.model.Group;
import com.zutubi.pulse.model.ManualTriggerBuildReason;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.ProjectGroup;
import com.zutubi.pulse.model.ProjectManager;
import com.zutubi.pulse.model.PulseFileDetails;
import com.zutubi.pulse.model.SubscriptionManager;
import com.zutubi.pulse.model.TemplatePulseFileDetails;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.model.persistence.BuildSpecificationDao;
import com.zutubi.pulse.model.persistence.BuildSpecificationNodeDao;
import com.zutubi.pulse.model.persistence.ProjectDao;
import com.zutubi.pulse.model.persistence.ProjectGroupDao;
import com.zutubi.pulse.model.persistence.TestCaseIndexDao;
import com.zutubi.pulse.model.persistence.TriggerDao;
import com.zutubi.pulse.personal.PatchArchive;
import com.zutubi.pulse.scheduling.EventTrigger;
import com.zutubi.pulse.scheduling.SCMChangeEventFilter;
import com.zutubi.pulse.scheduling.Scheduler;
import com.zutubi.pulse.scheduling.SchedulingException;
import com.zutubi.pulse.scheduling.Task;
import com.zutubi.pulse.scheduling.Trigger;
import com.zutubi.pulse.scheduling.tasks.BuildProjectTask;
import com.zutubi.pulse.scm.SCMChangeEvent;
import com.zutubi.pulse.scm.SCMException;
import com.zutubi.pulse.util.logging.Logger;
import java.io.Serializable;
import java.util.List;
import org.acegisecurity.annotation.Secured;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProjectManager
implements ProjectManager {
    public static final int DEFAULT_WORK_DIR_BUILDS = 10;
    private static final Logger LOG = Logger.getLogger(DefaultProjectManager.class);
    private ProjectDao projectDao;
    private ProjectGroupDao projectGroupDao;
    private BuildSpecificationDao buildSpecificationDao;
    private BuildSpecificationNodeDao buildSpecificationNodeDao;
    private TriggerDao triggerDao;
    private TestCaseIndexDao testCaseIndexDao;
    private Scheduler scheduler;
    private BuildManager buildManager;
    private SubscriptionManager subscriptionManager;
    private EventManager eventManager;
    private ChangelistIsolator changelistIsolator;
    private LicenseManager licenseManager;
    private UserManager userManager;
    private CustomAclEntryCache projectAclEntryCache;

    @Override
    public void save(Project project) {
        this.projectDao.save(project);
    }

    @Override
    public Project getProject(String name) {
        return this.projectDao.findByName(name);
    }

    @Override
    public Project getProject(long id) {
        return (Project)((Object)this.projectDao.findById(id));
    }

    @Override
    public Project getProjectByScm(long scmId) {
        return this.projectDao.findByScmId(scmId);
    }

    @Override
    public Project getProjectByBuildSpecification(BuildSpecification buildSpecification) {
        return this.projectDao.findByBuildSpecification(buildSpecification);
    }

    @Override
    public List<Project> getAllProjects() {
        return this.projectDao.findAll();
    }

    @Override
    public List<Project> getAllProjectsCached() {
        return this.projectDao.findAllProjectsCached();
    }

    @Override
    public List<Project> getProjectsWithNameLike(String name) {
        return this.projectDao.findByLikeName(name);
    }

    @Override
    public int getProjectCount() {
        return this.projectDao.count();
    }

    @Override
    public void save(BuildSpecification specification) {
        this.buildSpecificationDao.save(specification);
    }

    @Override
    public void setDefaultBuildSpecification(Project project, long specId) {
        BuildSpecification spec = project.getBuildSpecification(specId);
        if (spec == null) {
            throw new IllegalArgumentException("Unknown build specificaiton [" + specId + "]");
        }
        project.setDefaultSpecification(spec);
    }

    private void deleteProject(Project entity) {
        List<TestCaseIndex> tests;
        try {
            this.scheduler.unscheduleAllTriggers(entity.getId());
        }
        catch (SchedulingException e) {
            LOG.warning("Unable to unschedule triggers for project '" + entity.getName() + "'", (Throwable)((Object)e));
        }
        this.buildManager.deleteAllBuilds(entity);
        this.subscriptionManager.deleteAllSubscriptions(entity);
        this.userManager.removeReferencesToProject(entity);
        do {
            tests = this.testCaseIndexDao.findByProject(entity.getId(), 100);
            for (TestCaseIndex index : tests) {
                this.testCaseIndexDao.delete(index);
            }
        } while (tests.size() > 0);
        for (ProjectGroup group : this.projectGroupDao.findByProject(entity)) {
            group.remove(entity);
        }
        this.projectDao.delete(entity);
    }

    @Override
    public void delete(Project project) {
        if ((project = this.getProject(project.getId())) != null) {
            this.deleteProject(project);
        }
        this.licenseManager.refreshAuthorisations();
    }

    @Override
    @Secured(value={"ACL_PROJECT_WRITE"})
    public void checkWrite(Project project) {
    }

    @Override
    public Project cloneProject(Project project, String name, String description) {
        Project copy = project.copy(name, description);
        this.projectDao.save(copy);
        List<Trigger> triggers = this.scheduler.getTriggers(project.getId());
        for (Trigger t : triggers) {
            Trigger triggerCopy = t.copy(project, copy);
            try {
                this.scheduler.schedule(triggerCopy);
            }
            catch (SchedulingException e) {
                LOG.severe("Unable to schedule trigger: " + (Object)((Object)e));
            }
        }
        return copy;
    }

    @Override
    public void triggerBuild(Project project, String specification, BuildReason reason, Revision revision, boolean force) {
        BuildSpecification spec = project.getBuildSpecification(specification);
        if (spec == null) {
            LOG.warning("Request to build unknown specification '" + specification + "' of project '" + project.getName() + "'");
            return;
        }
        if (revision == null) {
            if (spec.getIsolateChangelists().booleanValue()) {
                try {
                    List<Revision> revisions = this.changelistIsolator.getRevisionsToRequest(project, spec, force);
                    for (Revision r : revisions) {
                        this.requestBuildOfRevision(reason, project, spec, r);
                    }
                }
                catch (SCMException e) {
                    LOG.error("Unable to determine revisions to build for project '" + project.getName() + "', specification '" + specification + "': " + e.getMessage(), (Throwable)e);
                }
            } else {
                this.eventManager.publish((Event)new BuildRequestEvent(this, reason, project, spec, new BuildRevision()));
            }
        } else {
            this.requestBuildOfRevision(reason, project, spec, revision);
        }
    }

    @Override
    public void triggerBuild(long number, Project project, BuildSpecification specification, User user, PatchArchive archive) throws PulseException {
        Revision revision = archive.getStatus().getRevision();
        try {
            String pulseFile = this.getPulseFile(project, revision, archive);
            this.eventManager.publish((Event)new PersonalBuildRequestEvent(this, number, new BuildRevision(revision, pulseFile, false), user, archive, project, specification));
        }
        catch (BuildException e) {
            throw new PulseException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public long getNextBuildNumber(Project project) {
        project = this.getProject(project.getId());
        long number = project.getNextBuildNumber();
        project.setNextBuildNumber(number + 1L);
        this.save(project);
        return number;
    }

    private void requestBuildOfRevision(BuildReason reason, Project project, BuildSpecification specification, Revision revision) {
        try {
            String pulseFile = this.getPulseFile(project, revision, null);
            this.eventManager.publish((Event)new BuildRequestEvent(this, reason, project, specification, new BuildRevision(revision, pulseFile, reason instanceof ManualTriggerBuildReason)));
        }
        catch (BuildException e) {
            LOG.severe("Unable to obtain pulse file for project '" + project.getName() + "', revision '" + revision.getRevisionString() + "': " + e.getMessage(), (Throwable)e);
        }
    }

    private String getPulseFile(Project project, Revision revision, PatchArchive patch) throws BuildException {
        PulseFileDetails pulseFileDetails = project.getPulseFileDetails();
        ComponentContext.autowire((Object)((Object)pulseFileDetails));
        return pulseFileDetails.getPulseFile(0L, project, revision, patch);
    }

    @Override
    public void updateProjectDetails(Project project, String name, String description, String url) throws SchedulingException {
        if (!(project = this.getProject(project.getId())).getName().equals(name)) {
            this.scheduler.renameProjectTriggers(project.getId(), name);
        }
        project.setName(name);
        project.setDescription(description);
        project.setUrl(url);
        this.projectDao.save(project);
    }

    @Override
    public List<Project> getProjectsWithAdmin(String authority) {
        return this.projectDao.findByAdminAuthority(authority);
    }

    @Override
    public void updateProjectAdmins(String authority, List<Long> restrictToProjects) {
        List<Project> projects = this.getAllProjects();
        for (Project p : projects) {
            if (restrictToProjects == null || restrictToProjects.contains(p.getId())) {
                p.addAdmin(authority);
            } else {
                p.removeAdmin(authority);
            }
            this.save(p);
            this.projectAclEntryCache.removeEntriesFromCache(p);
        }
    }

    @Override
    public void removeAcls(String authority) {
        List<Project> projects = this.projectDao.findByAdminAuthority(authority);
        for (Project p : projects) {
            p.removeAdmin(authority);
            this.save(p);
            this.projectAclEntryCache.removeEntriesFromCache(p);
        }
    }

    public void initialise() {
        this.changelistIsolator = new ChangelistIsolator(this.buildManager);
        AddProjectAuthorisation addProjectAuthorisation = new AddProjectAuthorisation();
        addProjectAuthorisation.setProjectManager(this);
        this.licenseManager.addAuthorisation(addProjectAuthorisation);
    }

    @Override
    public void deleteBuildSpecification(Project project, long specId) {
        BuildSpecification spec = (project = (Project)((Object)this.projectDao.findById(project.getId()))).getBuildSpecification(specId);
        if (spec == null) {
            throw new IllegalArgumentException("Unknown build specification [" + specId + "]");
        }
        if (project.getDefaultSpecification().equals((Object)spec)) {
            throw new IllegalArgumentException("The default build specification cannot be deleted");
        }
        List<Trigger> triggers = this.triggerDao.findByProject(project.getId());
        for (Trigger trigger : triggers) {
            long triggerSpecId;
            Class<? extends Task> clazz = trigger.getTaskClass();
            if (!clazz.equals(BuildProjectTask.class) || (triggerSpecId = ((Long)trigger.getDataMap().get("spec")).longValue()) != specId || !trigger.isScheduled()) continue;
            try {
                this.scheduler.unschedule(trigger);
            }
            catch (SchedulingException e) {
                throw new PulseRuntimeException("Unable to unschedule trigger [" + trigger.getId() + "]");
            }
        }
        project.remove(spec);
        this.buildSpecificationDao.delete(spec);
    }

    @Override
    @Secured(value={"ACL_PROJECT_WRITE"})
    public void deleteArtifact(Project project, long id) {
        if ((project = this.getProject(project.getId())) != null && project.getPulseFileDetails().isBuiltIn()) {
            TemplatePulseFileDetails details = (TemplatePulseFileDetails)project.getPulseFileDetails();
            Capture deadMan = null;
            for (Capture c : details.getCaptures()) {
                if (c.getId() != id) continue;
                deadMan = c;
                break;
            }
            if (deadMan != null) {
                details.removeCapture(deadMan);
            }
        }
    }

    @Override
    public void buildCommenced(long projectId) {
        Project project = this.getProject(projectId);
        if (project != null) {
            project.buildCommenced();
            this.projectDao.save(project);
        }
    }

    @Override
    public void buildCompleted(long projectId) {
        Project project = this.getProject(projectId);
        if (project != null) {
            project.buildCompleted();
            this.projectDao.save(project);
        }
    }

    @Override
    public Project pauseProject(Project project) {
        if ((project = this.getProject(project.getId())) != null) {
            project.pause();
            this.projectDao.save(project);
        }
        return project;
    }

    @Override
    public void resumeProject(Project project) {
        if ((project = this.getProject(project.getId())) != null) {
            project.resume();
            this.projectDao.save(project);
        }
    }

    @Override
    public void create(Project project) throws LicenseException {
        LicenseHolder.ensureAuthorization("canAddProject");
        for (Group group : this.userManager.getAdminAllProjectGroups()) {
            project.addAdmin(group.getDefaultAuthority());
        }
        BuildSpecification buildSpec = new BuildSpecification("default");
        project.addBuildSpecification(buildSpec);
        project.setDefaultSpecification(buildSpec);
        project.addCleanupRule(new CleanupRule(true, null, 10, CleanupRule.CleanupUnit.BUILDS));
        this.projectDao.save(project);
        BuildSpecificationNode parent = (BuildSpecificationNode)((Object)this.buildSpecificationNodeDao.findById(buildSpec.getRoot().getId()));
        BuildStage stage = new BuildStage("default", new AnyCapableBuildHostRequirements(), null);
        BuildSpecificationNode node = new BuildSpecificationNode(stage);
        parent.addChild(node);
        this.buildSpecificationNodeDao.save(parent);
        try {
            EventTrigger trigger = new EventTrigger(SCMChangeEvent.class, "scm trigger", project.getName(), SCMChangeEventFilter.class);
            trigger.setProject(project.getId());
            trigger.setTaskClass(BuildProjectTask.class);
            trigger.getDataMap().put((Serializable)((Object)"spec"), Long.valueOf(buildSpec.getId()));
            this.scheduler.schedule(trigger);
        }
        catch (SchedulingException e) {
            e.printStackTrace();
        }
        this.projectDao.save(project);
        this.licenseManager.refreshAuthorisations();
    }

    public void setProjectDao(ProjectDao dao) {
        this.projectDao = dao;
    }

    public void setBuildSpecificationDao(BuildSpecificationDao buildSpecificationDao) {
        this.buildSpecificationDao = buildSpecificationDao;
    }

    public void setTriggerDao(TriggerDao triggerDao) {
        this.triggerDao = triggerDao;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public void setSubscriptionManager(SubscriptionManager subscriptionManager) {
        this.subscriptionManager = subscriptionManager;
    }

    @Override
    public List<ProjectGroup> getAllProjectGroups() {
        return this.projectGroupDao.findAll();
    }

    @Override
    public List<ProjectGroup> getAllProjectGroupsCached() {
        return this.projectGroupDao.findAllCached();
    }

    @Override
    public ProjectGroup getProjectGroup(long id) {
        return (ProjectGroup)((Object)this.projectGroupDao.findById(id));
    }

    @Override
    public ProjectGroup getProjectGroup(String name) {
        return this.projectGroupDao.findByName(name);
    }

    @Override
    public void save(ProjectGroup projectGroup) {
        this.projectGroupDao.save(projectGroup);
    }

    @Override
    @Secured(value={"ROLE_ADMINISTRATOR"})
    public void delete(ProjectGroup projectGroup) {
        this.userManager.removeReferencesToProjectGroup(projectGroup);
        this.projectGroupDao.delete(projectGroup);
    }

    @Override
    public Project getProjectByCleanupRule(CleanupRule rule) {
        return this.projectDao.findByCleanupRule(rule);
    }

    @Override
    public BuildSpecification getBuildSpecification(long id) {
        return (BuildSpecification)((Object)this.buildSpecificationDao.findById(id));
    }

    @Override
    public void delete(BuildHostRequirements hostRequirements) {
        this.buildSpecificationDao.delete(hostRequirements);
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setProjectGroupDao(ProjectGroupDao projectGroupDao) {
        this.projectGroupDao = projectGroupDao;
    }

    public void setBuildSpecificationNodeDao(BuildSpecificationNodeDao buildSpecificationNodeDao) {
        this.buildSpecificationNodeDao = buildSpecificationNodeDao;
    }

    public void setTestCaseIndexDao(TestCaseIndexDao testCaseIndexDao) {
        this.testCaseIndexDao = testCaseIndexDao;
    }

    public void setProjectAclEntryCache(CustomAclEntryCache projectAclEntryCache) {
        this.projectAclEntryCache = projectAclEntryCache;
    }
}

