/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.ConfigurableResourceRepository;
import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.ResourceRepository;
import com.zutubi.pulse.core.model.Resource;
import com.zutubi.pulse.core.model.ResourceVersion;
import com.zutubi.pulse.model.PersistentResource;
import com.zutubi.pulse.model.Slave;
import com.zutubi.pulse.model.persistence.ResourceDao;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseResourceRepository
implements ConfigurableResourceRepository {
    private Slave slave;
    private ResourceRepository parent;
    private ResourceDao resourceDao;

    public DatabaseResourceRepository(ResourceDao resourceDao) {
        this.slave = null;
        this.resourceDao = resourceDao;
    }

    public DatabaseResourceRepository(Slave slave, ResourceDao resourceDao) {
        this.slave = slave;
        this.resourceDao = resourceDao;
    }

    public boolean hasResource(String name, String version) {
        Resource r = this.getResource(name);
        return r != null && (version == null || r.hasVersion(version));
    }

    public boolean hasResource(String name) {
        return this.getResource(name) != null;
    }

    public Resource getResource(String name) {
        if (this.parent != null && this.parent.hasResource(name)) {
            return this.parent.getResource(name);
        }
        return this.resourceDao.findBySlaveAndName(this.slave, name);
    }

    public List<String> getResourceNames() {
        LinkedList<String> names = this.parent != null ? this.parent.getResourceNames() : new LinkedList<String>();
        for (PersistentResource resource : this.resourceDao.findAllBySlave(this.slave)) {
            if (names.contains(resource.getName())) continue;
            names.add(resource.getName());
        }
        return names;
    }

    public void setParent(ResourceRepository parent) {
        this.parent = parent;
    }

    public void addResource(Resource resource) {
        this.addResource(resource, false);
    }

    public void addResource(Resource resource, boolean overwrite) {
        PersistentResource existingResource = this.resourceDao.findBySlaveAndName(this.slave, resource.getName());
        if (existingResource == null) {
            this.resourceDao.save(new PersistentResource(resource, this.slave));
            return;
        }
        for (String propertyName : resource.getProperties().keySet()) {
            if (existingResource.hasProperty(propertyName) && overwrite) {
                existingResource.deleteProperty(propertyName);
                existingResource.addProperty(resource.getProperty(propertyName));
                continue;
            }
            if (existingResource.hasProperty(propertyName)) continue;
            existingResource.addProperty(resource.getProperty(propertyName));
        }
        for (String versionStr : resource.getVersions().keySet()) {
            if (!existingResource.hasVersion(versionStr)) {
                existingResource.add(resource.getVersion(versionStr));
                continue;
            }
            ResourceVersion version = resource.getVersion(versionStr);
            ResourceVersion existingVersion = existingResource.getVersion(versionStr);
            for (String propertyName : version.getProperties().keySet()) {
                try {
                    if (existingVersion.hasProperty(propertyName) && overwrite) {
                        existingVersion.deleteProperty(propertyName);
                        existingVersion.addProperty(version.getProperty(propertyName));
                        continue;
                    }
                    if (existingVersion.hasProperty(propertyName)) continue;
                    existingVersion.addProperty(version.getProperty(propertyName));
                }
                catch (FileLoadException e) {
                    e.printStackTrace();
                }
            }
        }
        this.resourceDao.save(existingResource);
    }
}

