/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.persistence.BuildResultDao;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanupRule
extends Entity {
    private boolean workDirOnly;
    private ResultState[] states;
    private int limit;
    private CleanupUnit unit;

    public CleanupRule() {
    }

    public CleanupRule(boolean workDirOnly, ResultState[] states, int count, CleanupUnit unit) {
        this.workDirOnly = workDirOnly;
        this.states = states;
        this.limit = count;
        this.unit = unit;
    }

    public CleanupRule copy() {
        ResultState[] clonedStates = null;
        if (this.states != null) {
            clonedStates = new ResultState[this.states.length];
            System.arraycopy(this.states, 0, clonedStates, 0, this.states.length);
        }
        return new CleanupRule(this.workDirOnly, clonedStates, this.limit, this.unit);
    }

    List<BuildResult> getMatchingResults(Project project, BuildResultDao dao) {
        ResultState[] allowedStates;
        Boolean hasWorkDir = null;
        if (this.workDirOnly) {
            hasWorkDir = true;
        }
        if ((allowedStates = this.states) == null) {
            allowedStates = ResultState.getCompletedStates();
        }
        if (this.unit == CleanupUnit.BUILDS) {
            int total = dao.getBuildCount(project, allowedStates, hasWorkDir);
            if (total > this.limit) {
                return dao.queryBuilds(new Project[]{project}, allowedStates, null, 0L, 0L, hasWorkDir, 0, total - this.limit, false);
            }
        } else {
            long startTime = System.currentTimeMillis() - (long)this.limit * 86400000L;
            return dao.queryBuilds(new Project[]{project}, allowedStates, null, 0L, startTime, hasWorkDir, -1, -1, false);
        }
        return new LinkedList<BuildResult>();
    }

    public boolean getWorkDirOnly() {
        return this.workDirOnly;
    }

    public void setWorkDirOnly(boolean workDirOnly) {
        this.workDirOnly = workDirOnly;
    }

    public ResultState[] getStates() {
        return this.states;
    }

    public void setStates(ResultState[] states) {
        this.states = states;
    }

    public String getStateNames() {
        String result = "";
        if (this.states != null) {
            for (ResultState state : this.states) {
                if (result.length() > 0) {
                    result = result + ",";
                }
                result = result + state.toString();
            }
        }
        return result;
    }

    public void setStateNames(String stateNames) {
        if (stateNames.length() > 0) {
            String[] names = stateNames.split(",");
            this.states = new ResultState[names.length];
            for (int i = 0; i < names.length; ++i) {
                this.states[i] = ResultState.valueOf((String)names[i]);
            }
        } else {
            this.states = null;
        }
    }

    public String getPrettyStateNames() {
        if (this.states == null) {
            return "any";
        }
        String result = "";
        for (ResultState state : this.states) {
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + state.getPrettyString();
        }
        return result;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public CleanupUnit getUnit() {
        return this.unit;
    }

    public void setUnit(CleanupUnit unit) {
        this.unit = unit;
    }

    public String getUnitName() {
        return this.unit.toString();
    }

    public void setUnitName(String name) {
        this.unit = CleanupUnit.valueOf(name);
    }

    public String getPrettyWhen() {
        if (this.unit == CleanupUnit.BUILDS) {
            return this.limit + " builds";
        }
        return this.limit + " days";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CleanupUnit {
        BUILDS,
        DAYS;

    }
}

