/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.model.PersistentName;
import com.zutubi.pulse.core.model.Revision;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.BuildScmDetails;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.scm.SCMException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangelistIsolator {
    private Map<Long, Revision> latestRequestedRevisions = new TreeMap<Long, Revision>();
    private BuildManager buildManager;

    public ChangelistIsolator(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public synchronized List<Revision> getRevisionsToRequest(Project project, BuildSpecification specification, boolean force) throws SCMException {
        Revision latestBuiltRevision = null;
        if (this.latestRequestedRevisions.containsKey(specification.getId())) {
            latestBuiltRevision = this.latestRequestedRevisions.get(specification.getId());
        } else {
            latestBuiltRevision = this.getLatestBuiltRevision(project, specification);
            if (latestBuiltRevision != null) {
                this.latestRequestedRevisions.put(specification.getId(), latestBuiltRevision);
            }
        }
        List<Revision> result = latestBuiltRevision == null ? Arrays.asList(project.getScm().createServer().getLatestRevision()) : project.getScm().createServer().getRevisionsSince(latestBuiltRevision);
        if (result.size() > 0) {
            this.latestRequestedRevisions.put(specification.getId(), result.get(result.size() - 1));
        } else if (force) {
            result = Arrays.asList(latestBuiltRevision.copy());
        }
        return result;
    }

    private Revision getLatestBuiltRevision(Project project, BuildSpecification specification) {
        int first = 0;
        while (true) {
            List<BuildResult> latest;
            if ((latest = this.buildManager.queryBuilds(new Project[]{project}, null, new PersistentName[]{specification.getPname()}, -1L, -1L, null, first, 1, true)).size() > 0) {
                BuildScmDetails scmDetails = latest.get(0).getScmDetails();
                if (scmDetails != null) {
                    return scmDetails.getRevision();
                }
            } else {
                return null;
            }
            ++first;
        }
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }
}

