/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.core.model.PersistentName;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.model.BuildSpecificationNode;
import com.zutubi.pulse.model.NamedEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildSpecification
extends Entity
implements NamedEntity {
    public static final int TIMEOUT_NEVER = 0;
    private PersistentName pname;
    private boolean isolateChangelists = false;
    private boolean retainWorkingCopy = false;
    private int timeout = 0;
    private CheckoutScheme checkoutScheme = CheckoutScheme.CLEAN_CHECKOUT;
    private BuildSpecificationNode root = new BuildSpecificationNode(null);
    private boolean forceClean;
    private List<ResourceProperty> properties = new LinkedList<ResourceProperty>();
    private boolean prompt = false;

    public BuildSpecification() {
    }

    public BuildSpecification(String name) {
        this.pname = new PersistentName(name);
    }

    public BuildSpecification copy() {
        BuildSpecification copy = new BuildSpecification(this.pname.getName());
        copy.timeout = this.timeout;
        copy.retainWorkingCopy = this.retainWorkingCopy;
        copy.isolateChangelists = this.isolateChangelists;
        copy.checkoutScheme = this.checkoutScheme;
        copy.root = this.root.copy();
        copy.properties = this.copyProperties();
        copy.prompt = this.prompt;
        return copy;
    }

    public String getName() {
        if (this.pname == null) {
            return null;
        }
        return this.pname.getName();
    }

    public void setName(String name) {
        if (this.pname == null) {
            this.pname = new PersistentName(name);
        } else {
            this.pname.setName(name);
        }
    }

    public PersistentName getPname() {
        return this.pname;
    }

    public void setPname(PersistentName pname) {
        this.pname = pname;
    }

    public Boolean getIsolateChangelists() {
        return this.isolateChangelists;
    }

    public void setIsolateChangelists(Boolean isolateChangelists) {
        if (isolateChangelists == null) {
            isolateChangelists = Boolean.FALSE;
        }
        this.isolateChangelists = isolateChangelists;
    }

    public boolean getRetainWorkingCopy() {
        return this.retainWorkingCopy;
    }

    public void setRetainWorkingCopy(boolean retainWorkingCopy) {
        this.retainWorkingCopy = retainWorkingCopy;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public String getPrettyTimeout() {
        if (this.timeout == 0) {
            return "[never]";
        }
        return this.timeout + " minutes";
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public CheckoutScheme getCheckoutScheme() {
        return this.checkoutScheme;
    }

    public void setCheckoutScheme(CheckoutScheme checkoutScheme) {
        this.checkoutScheme = checkoutScheme;
    }

    private String getCheckoutSchemeName() {
        return this.checkoutScheme.toString();
    }

    private void setCheckoutSchemeName(String str) {
        this.checkoutScheme = CheckoutScheme.valueOf(str);
    }

    public BuildSpecificationNode getRoot() {
        return this.root;
    }

    public void setRoot(BuildSpecificationNode root) {
        this.root = root;
    }

    public BuildSpecificationNode getNode(long id) {
        return this.root.getNode(id);
    }

    public BuildSpecificationNode getNodeByStageName(String name) {
        return this.root.getNodeByStageName(name);
    }

    public boolean getForceClean() {
        return this.forceClean;
    }

    public void setForceClean(boolean forceClean) {
        this.forceClean = forceClean;
    }

    public List<ResourceProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<ResourceProperty> properties) {
        this.properties = properties;
    }

    public ResourceProperty getProperty(long id) {
        for (ResourceProperty p : this.properties) {
            if (p.getId() != id) continue;
            return p;
        }
        return null;
    }

    public ResourceProperty getProperty(String name) {
        for (ResourceProperty p : this.properties) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public boolean hasProperty(String name) {
        return this.getProperty(name) != null;
    }

    public void removeProperty(long id) {
        Iterator<ResourceProperty> it = this.properties.iterator();
        while (it.hasNext()) {
            if (it.next().getId() != id) continue;
            it.remove();
            return;
        }
    }

    public void addProperty(ResourceProperty property) {
        this.properties.add(property);
    }

    public List<ResourceProperty> copyProperties() {
        ArrayList<ResourceProperty> result = new ArrayList<ResourceProperty>(this.properties.size());
        for (ResourceProperty property : this.properties) {
            ResourceProperty copyProperty = property.copy();
            result.add(copyProperty);
        }
        return result;
    }

    public boolean getPrompt() {
        return this.prompt;
    }

    public void setPrompt(boolean prompt) {
        this.prompt = prompt;
    }

    public boolean equals(Object other) {
        return super.equals(other);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CheckoutScheme {
        CLEAN_CHECKOUT,
        CLEAN_UPDATE,
        INCREMENTAL_UPDATE;

    }
}

