/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.zutubi.pulse.core.model.Entity;
import com.zutubi.pulse.core.model.Feature;
import com.zutubi.pulse.core.model.PersistentName;
import com.zutubi.pulse.core.model.RecipeResult;
import com.zutubi.pulse.core.model.Result;
import com.zutubi.pulse.core.model.ResultState;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.core.model.TestResultSummary;
import com.zutubi.pulse.model.BuildReason;
import com.zutubi.pulse.model.BuildScmDetails;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.PersonalBuildReason;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.model.User;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.AclObjectIdentityAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildResult
extends Result
implements AclObjectIdentityAware,
Iterable<RecipeResultNode> {
    public static final String PULSE_FILE = "pulse.xml";
    private BuildReason reason;
    private Project project;
    private User user;
    private PersistentName specName;
    private long number;
    private boolean userRevision;
    private BuildScmDetails scmDetails;
    private RecipeResultNode root;
    private String version;
    private boolean hasWorkDir;

    public BuildResult() {
    }

    public BuildResult(BuildReason reason, Project project, BuildSpecification spec, long number, boolean userRevision) {
        try {
            this.reason = (BuildReason)reason.clone();
        }
        catch (CloneNotSupportedException e) {
            this.reason = reason;
        }
        this.project = project;
        this.user = null;
        this.specName = spec.getPname();
        this.number = number;
        this.userRevision = userRevision;
        this.state = ResultState.INITIAL;
        this.root = new RecipeResultNode(null, null);
        this.hasWorkDir = true;
    }

    public BuildResult(User user, Project project, BuildSpecification spec, long number) {
        this(new PersonalBuildReason(user.getLogin()), project, spec, number, false);
        this.user = user;
    }

    public BuildReason getReason() {
        return this.reason;
    }

    private void setReason(BuildReason reason) {
        this.reason = reason;
    }

    public Project getProject() {
        return this.project;
    }

    private void setProject(Project project) {
        this.project = project;
    }

    public User getUser() {
        return this.user;
    }

    private void setUser(User user) {
        this.user = user;
    }

    public String getBuildSpecification() {
        return this.specName.getName();
    }

    public PersistentName getSpecName() {
        return this.specName;
    }

    private void setSpecName(PersistentName specName) {
        this.specName = specName;
    }

    public long getNumber() {
        return this.number;
    }

    private void setNumber(long number) {
        this.number = number;
    }

    public boolean isUserRevision() {
        return this.userRevision;
    }

    private void setUserRevision(boolean userRevision) {
        this.userRevision = userRevision;
    }

    public RecipeResultNode getRoot() {
        return this.root;
    }

    private void setRoot(RecipeResultNode root) {
        this.root = root;
    }

    public boolean getHasWorkDir() {
        return this.hasWorkDir;
    }

    public void setHasWorkDir(boolean hasWorkDir) {
        this.hasWorkDir = hasWorkDir;
    }

    public void abortUnfinishedRecipes() {
        for (RecipeResultNode node : this.root.getChildren()) {
            node.abort();
        }
    }

    public List<String> collectErrors() {
        List errors = super.collectErrors();
        for (RecipeResultNode node : this.root.getChildren()) {
            errors.addAll(node.collectErrors());
        }
        return errors;
    }

    public boolean hasMessages(Feature.Level level) {
        if (this.hasDirectMessages(level)) {
            return true;
        }
        for (RecipeResultNode node : this.root.getChildren()) {
            if (!node.hasMessages(level)) continue;
            return true;
        }
        return false;
    }

    public boolean hasArtifacts() {
        for (RecipeResultNode node : this.root.getChildren()) {
            if (!node.hasArtifacts()) continue;
            return true;
        }
        return false;
    }

    public BuildScmDetails getScmDetails() {
        return this.scmDetails;
    }

    public void setScmDetails(BuildScmDetails scmDetails) {
        this.scmDetails = scmDetails;
    }

    public AclObjectIdentity getAclObjectIdentity() {
        return this.project;
    }

    public RecipeResultNode findResultNode(long id) {
        return this.root.findNode(id);
    }

    public RecipeResultNode findResultNode(PersistentName stage) {
        return this.root.findNode(stage);
    }

    public StoredArtifact findArtifact(String artifactName) {
        for (RecipeResultNode child : this.root.getChildren()) {
            StoredArtifact artifact = child.findArtifact(artifactName);
            if (artifact == null) continue;
            return artifact;
        }
        return null;
    }

    public void complete() {
        this.state = this.root.getWorstState(this.state);
        super.complete();
    }

    @Override
    public Iterator<RecipeResultNode> iterator() {
        return new ResultIterator();
    }

    public boolean isPersonal() {
        return this.user != null;
    }

    public Entity getOwner() {
        if (this.user == null) {
            return this.project;
        }
        return this.user;
    }

    public void loadFailedTestResults(File dataRoot, int limitPerRecipe) {
        this.root.loadFailedTestResults(dataRoot, limitPerRecipe);
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public TestResultSummary getTestSummary() {
        return this.root.getTestSummary();
    }

    public boolean hasTests() {
        return this.getTestSummary().getTotal() > 0;
    }

    public boolean hasBrokenTests() {
        return this.getTestSummary().getBroken() > 0;
    }

    public void calculateFeatureCounts() {
        super.calculateFeatureCounts();
        this.calculateNodeFeatureCounts(this.root);
    }

    private void calculateNodeFeatureCounts(RecipeResultNode node) {
        RecipeResult result = node.getResult();
        if (result != null) {
            result.calculateFeatureCounts();
            this.warningFeatureCount += result.getWarningFeatureCount();
            this.errorFeatureCount += result.getErrorFeatureCount();
        }
        for (RecipeResultNode child : node.getChildren()) {
            this.calculateNodeFeatureCounts(child);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResultIterator
    implements Iterator<RecipeResultNode> {
        List<RecipeResultNode> remaining;

        public ResultIterator() {
            this.remaining = new LinkedList<RecipeResultNode>(BuildResult.this.root.getChildren());
        }

        @Override
        public boolean hasNext() {
            return this.remaining.size() > 0;
        }

        @Override
        public RecipeResultNode next() {
            RecipeResultNode next = this.remaining.remove(0);
            this.remaining.addAll(next.getChildren());
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Build result may not have recipes removed");
        }
    }
}

