/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.model;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.model.TemplatePulseFileDetails;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.velocity.VelocityContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntPulseFileDetails
extends TemplatePulseFileDetails {
    private String buildFile;
    private String targets;
    private String arguments;
    private String workingDir;
    private Map<String, String> environment = new TreeMap<String, String>();

    public AntPulseFileDetails() {
    }

    public AntPulseFileDetails(String buildFile, String targets, String arguments, String workingDir, Map<String, String> environment) {
        this.buildFile = buildFile;
        this.targets = targets;
        this.arguments = arguments;
        this.workingDir = workingDir;
        if (environment != null) {
            this.environment.putAll(environment);
        }
    }

    @Override
    public AntPulseFileDetails copy() {
        TreeMap<String, String> env = new TreeMap<String, String>(this.environment);
        AntPulseFileDetails copy = new AntPulseFileDetails(this.buildFile, this.targets, this.arguments, this.workingDir, env);
        this.copyCommon(copy);
        return copy;
    }

    @Override
    protected String getTemplateName() {
        return "ant.template.vm";
    }

    @Override
    protected void populateContext(VelocityContext context) {
        if (TextUtils.stringSet((String)this.buildFile)) {
            context.put("buildFile", (Object)this.buildFile);
        }
        if (TextUtils.stringSet((String)this.targets)) {
            context.put("targets", (Object)this.targets);
        }
        if (TextUtils.stringSet((String)this.arguments)) {
            context.put("arguments", (Object)this.arguments);
        }
        if (TextUtils.stringSet((String)this.workingDir)) {
            context.put("workingDir", (Object)this.workingDir);
        }
        context.put("environment", this.environment);
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public void setBuildFile(String buildFile) {
        this.buildFile = buildFile;
    }

    public String getTargets() {
        return this.targets;
    }

    public void setTargets(String targets) {
        this.targets = targets;
    }

    public String getArguments() {
        return this.arguments;
    }

    public void setArguments(String arguments) {
        this.arguments = arguments;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public void addEnvironmentalVariable(String name, String value) {
        this.environment.put(name, value);
    }

    @Override
    public String getType() {
        return "ant";
    }

    @Override
    public Properties getProperties() {
        String env;
        Properties result = new Properties();
        if (TextUtils.stringSet((String)this.buildFile)) {
            result.put("build file", this.buildFile);
        }
        if (TextUtils.stringSet((String)this.targets)) {
            result.put("targets", this.targets);
        }
        if (TextUtils.stringSet((String)this.arguments)) {
            result.put("arguments", this.arguments);
        }
        if (TextUtils.stringSet((String)this.workingDir)) {
            result.put("working directory", this.workingDir);
        }
        if (TextUtils.stringSet((String)(env = this.getEnvironmentString()))) {
            result.put("environment", env);
        }
        return result;
    }

    private String getEnvironmentString() {
        StringBuilder result = new StringBuilder();
        String sep = "";
        for (Map.Entry<String, String> entry : this.environment.entrySet()) {
            result.append(sep);
            result.append((Object)entry.getKey());
            result.append('=');
            result.append((Object)entry.getValue());
            sep = "; ";
        }
        return result.toString();
    }
}

