/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.license;

import com.zutubi.pulse.license.License;
import com.zutubi.pulse.license.LicenseException;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseHolder {
    public static final String AUTH_ADD_AGENT = "canAddAgent";
    public static final String AUTH_ADD_PROJECT = "canAddProject";
    public static final String AUTH_ADD_USER = "canAddUser";
    public static final String AUTH_RUN_PULSE = "canRunPulse";
    private static License license;
    private static List<String> authorisations;

    public static synchronized License getLicense() {
        return license;
    }

    public static synchronized void setLicense(License l) {
        license = l;
    }

    public static synchronized boolean hasAuthorization(String auth) {
        return authorisations.contains(auth);
    }

    public static synchronized void ensureAuthorization(String ... auths) throws LicenseException {
        for (String auth : auths) {
            if (LicenseHolder.hasAuthorization(auth)) continue;
            throw new LicenseException();
        }
    }

    public static synchronized void setAuthorizations(List<String> authorisations) {
        LicenseHolder.authorisations = authorisations;
    }

    static {
        authorisations = new LinkedList<String>();
    }
}

