/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.license;

import com.zutubi.pulse.license.License;
import com.zutubi.pulse.license.LicenseDecoder;
import com.zutubi.pulse.license.LicenseEncoder;
import com.zutubi.pulse.license.LicenseException;
import com.zutubi.pulse.license.LicenseType;
import com.zutubi.pulse.test.PulseTestCase;
import com.zutubi.pulse.util.RandomUtils;
import java.util.Calendar;

public class LicenseEncodeDecodeTest
extends PulseTestCase {
    private LicenseEncoder encoder;
    private LicenseDecoder decoder;
    private static final String LICENSE_V1 = "AAAAOUVWQUxVQVRJT04KUy4gTy4gTWVCb2R5CjIwMDYtMTAtMTkgMTE6MjY6MjEgRVNUCjEyCjM0CjU2CgLWL3MGBkF68yRbQ4BAjuU7XmO/uJp7jOGFTk5s0y7aPiuzxTEuQ/1216+Y+M1n8kQEfZsSSB4dfB/qIynqHdl0EJsvozdORIALcRrAXByhcBKIQE3KfJg/fPhm4Nmfy6Hic9gMeioXjpf6meDSOfnP1F9sOnIh2E1B70Ou3zP0";

    public LicenseEncodeDecodeTest() {
    }

    public LicenseEncodeDecodeTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.encoder = new LicenseEncoder();
        this.decoder = new LicenseDecoder();
    }

    protected void tearDown() throws Exception {
        this.encoder = null;
        this.decoder = null;
        super.tearDown();
    }

    public void testSimpleLicenseEncoding() throws Exception {
        License e = new License(LicenseType.EVALUATION, "S. O MeBody", null);
        LicenseEncodeDecodeTest.assertEquals((Object)e, (Object)this.decoder.decode(this.encoder.encode(e)));
        License c = new License(LicenseType.STANDARD, "Nob. Ody", null);
        LicenseEncodeDecodeTest.assertEquals((Object)c, (Object)this.decoder.decode(this.encoder.encode(c)));
        License n = new License(LicenseType.NON_PROFIT, "S. O MeBody", null);
        LicenseEncodeDecodeTest.assertEquals((Object)n, (Object)this.decoder.decode(this.encoder.encode(n)));
    }

    public void testLongLicenseEncoding() throws LicenseException {
        License l = new License(LicenseType.EVALUATION, RandomUtils.randomString((int)128), null);
        LicenseEncodeDecodeTest.assertEquals((Object)l, (Object)this.decoder.decode(this.encoder.encode(l)));
    }

    public void testEncodingOfExpiryDate() throws LicenseException {
        Calendar now = Calendar.getInstance();
        now.set(14, 0);
        License l = new License(LicenseType.EVALUATION, "S. O. MeBody", now.getTime());
        LicenseEncodeDecodeTest.assertEquals((Object)l, (Object)this.decoder.decode(this.encoder.encode(l)));
    }

    public void testDecodeInvalidLength() throws LicenseException {
        LicenseDecoder decoder = new LicenseDecoder();
        LicenseEncodeDecodeTest.assertNull((Object)decoder.decode("SADFA".getBytes()));
    }

    public void testEncodingOfSupportedEntities() throws LicenseException {
        License l = new License(LicenseType.EVALUATION, "S. O. MeBody", null);
        l.setSupported(12, 34, 56);
        LicenseEncodeDecodeTest.assertEquals((Object)l, (Object)this.decoder.decode(this.encoder.encode(l)));
    }

    public void testBackwardCompatibilityOfLicense() throws LicenseException {
        License l = this.decoder.decode(LICENSE_V1.getBytes());
        LicenseEncodeDecodeTest.assertEquals((int)12, (int)l.getSupportedAgents());
        LicenseEncodeDecodeTest.assertEquals((int)34, (int)l.getSupportedProjects());
        LicenseEncodeDecodeTest.assertEquals((int)56, (int)l.getSupportedUsers());
        LicenseEncodeDecodeTest.assertEquals((int)-1, (int)l.getSupportedContactPoints());
        LicenseEncodeDecodeTest.assertEquals((int)0, (int)l.getDaysRemaining());
        LicenseEncodeDecodeTest.assertEquals((String)"S. O. MeBody", (String)l.getHolder());
        LicenseEncodeDecodeTest.assertEquals((Object)((Object)LicenseType.EVALUATION), (Object)((Object)l.getType()));
        LicenseEncodeDecodeTest.assertTrue((boolean)l.expires());
        LicenseEncodeDecodeTest.assertTrue((boolean)l.isExpired());
    }
}

