/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.jetty;

import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.Stoppable;
import com.zutubi.pulse.util.logging.Logger;
import java.io.File;
import java.net.BindException;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.WebApplicationContext;
import org.mortbay.jetty.servlet.WebApplicationHandler;
import org.mortbay.util.MultiException;

public class JettyManager
implements Stoppable {
    private static final Logger LOG = Logger.getLogger(JettyManager.class);
    private Server server;
    private MasterConfigurationManager configurationManager;
    private WebApplicationContext appContext;

    public void setJettyServer(Server server) {
        this.server = server;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void start() {
        if (this.isStarted()) {
            LOG.warning("Request to start jetty server ignored. Server already started.");
            return;
        }
        File wwwRoot = this.configurationManager.getSystemPaths().getContentRoot();
        try {
            this.appContext = this.server.addWebApplication(this.getContextPath(), wwwRoot.getAbsolutePath());
            this.appContext.setDefaultsDescriptor(null);
            File tmpRoot = this.configurationManager.getSystemPaths().getTmpRoot();
            if (!tmpRoot.exists()) {
                tmpRoot.mkdirs();
            }
            this.appContext.setAttribute("javax.servlet.context.tempdir", (Object)tmpRoot);
            this.server.start();
        }
        catch (MultiException e) {
            for (Exception nested : e.getExceptions()) {
                if (nested instanceof BindException) {
                    this.handleBindException();
                    continue;
                }
                LOG.severe("Unable to start server: " + nested.getMessage(), (Throwable)nested);
            }
            System.exit(1);
        }
        catch (Exception e) {
            LOG.severe("Unable to start server: " + e.getMessage(), (Throwable)e);
            System.exit(1);
        }
    }

    private void handleBindException() {
        int port = this.configurationManager.getSystemConfig().getServerPort();
        LOG.severe(String.format("Pulse is unable to start on port %s because it is being used by another process.  Please select a different port and restart pulse.", port));
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    public WebApplicationContext getApplicationContext() {
        return this.appContext;
    }

    public void stop(boolean force) {
        try {
            if (this.server.isStarted()) {
                this.server.stop(true);
            }
        }
        catch (InterruptedException e) {
            LOG.severe("Error while stopping Jetty", (Throwable)e);
        }
    }

    public WebApplicationHandler getHandler() {
        if (this.server.isStarted()) {
            return (WebApplicationHandler)this.server.getContext(this.getContextPath()).getHandlers()[0];
        }
        return null;
    }

    protected String getContextPath() {
        return this.configurationManager.getSystemConfig().getContextPath();
    }
}

