/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.freemarker;

import com.opensymphony.webwork.views.freemarker.FreemarkerManager;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.bootstrap.SystemPaths;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.log.Logger;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletContext;

public class CustomFreemarkerManager
extends FreemarkerManager {
    private static final com.zutubi.pulse.util.logging.Logger LOG = com.zutubi.pulse.util.logging.Logger.getLogger(CustomFreemarkerManager.class);
    private MasterConfigurationManager configManager;

    public static void initialiseLogging() {
        try {
            Logger.selectLoggerLibrary((int)1);
        }
        catch (ClassNotFoundException e) {
            LOG.severe("Unable to set freemarker logger: " + e.getMessage(), (Throwable)e);
        }
    }

    public TemplateLoader[] getLoaders(TemplateLoader superLoader) {
        SystemPaths paths = this.configManager.getSystemPaths();
        List templateRoots = paths.getTemplateRoots();
        TemplateLoader[] loaders = new TemplateLoader[templateRoots.size() + 1];
        for (int i = 0; i < templateRoots.size(); ++i) {
            try {
                loaders[i] = new FileTemplateLoader((File)templateRoots.get(i));
                continue;
            }
            catch (IOException e) {
                LOG.severe((Throwable)e);
            }
        }
        loaders[loaders.length - 1] = superLoader;
        return loaders;
    }

    protected TemplateLoader getTemplateLoader(ServletContext servletContext) {
        TemplateLoader superLoader = super.getTemplateLoader(servletContext);
        return new MultiTemplateLoader(this.getLoaders(superLoader));
    }

    public void setConfigurationManager(MasterConfigurationManager configManager) {
        this.configManager = configManager;
    }
}

