/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.form.ui.renderers;

import com.zutubi.pulse.form.ui.TemplateRenderer;
import com.zutubi.pulse.form.ui.TemplateRendererContext;
import com.zutubi.pulse.util.logging.Logger;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;

public class FreemarkerTemplateRenderer
implements TemplateRenderer {
    private static final Logger LOG = Logger.getLogger(FreemarkerTemplateRenderer.class);
    private Configuration configuration;
    private static final String DEFAULT_TEMPLATE_DIR = "forms";
    private static final String DEFAULT_THEME = "custom";
    private String templateDir = "forms";
    private String theme = "custom";

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public void render(TemplateRendererContext rendererContext) throws Exception {
        String templateName = "/" + this.templateDir + "/" + this.theme + "/" + rendererContext.getName() + ".ftl";
        HashMap<String, Object> context = new HashMap<String, Object>();
        Map<String, Object> params = rendererContext.getParameters();
        if (!params.containsKey("templateDir")) {
            params.put("templateDir", this.templateDir);
        }
        if (!params.containsKey("theme")) {
            params.put("theme", this.theme);
        }
        context.put("parameters", rendererContext.getParameters());
        context.put("fieldErrors", rendererContext.get("fieldErrors"));
        try {
            Template template = this.configuration.getTemplate(templateName);
            template.process(context, rendererContext.getWriter());
        }
        catch (FileNotFoundException e) {
            LOG.warning(e.getMessage());
        }
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }
}

