/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.form.ui;

import com.zutubi.pulse.form.descriptor.ActionDescriptor;
import com.zutubi.pulse.form.descriptor.DefaultActionDescriptor;
import com.zutubi.pulse.form.descriptor.DefaultFieldDescriptor;
import com.zutubi.pulse.form.descriptor.FieldDescriptor;
import com.zutubi.pulse.form.descriptor.FormDescriptor;
import com.zutubi.pulse.wizard.Wizard;
import com.zutubi.pulse.wizard.WizardTransition;
import java.util.LinkedList;
import java.util.List;

public class WizardDecorator {
    private String state;
    private List<WizardTransition> transitions;

    public WizardDecorator(Wizard wizard) {
        this.state = wizard.getCurrentState().getClass().getName();
        this.transitions = wizard.getAvailableActions();
    }

    public FormDescriptor decorate(FormDescriptor descriptor) {
        String defaultAction = "next";
        if (this.transitions.contains((Object)WizardTransition.FINISH)) {
            defaultAction = "finish";
        }
        for (FieldDescriptor fieldDescriptor : descriptor.getFieldDescriptors()) {
            fieldDescriptor.getParameters().put("onkeypress", "return submitenter(this, event, '" + defaultAction + "')");
        }
        DefaultFieldDescriptor submitField = new DefaultFieldDescriptor();
        submitField.setFieldType("hidden");
        submitField.setName("submit");
        submitField.setType(String.class);
        descriptor.addFieldDescriptor(submitField);
        DefaultFieldDescriptor stateField = new DefaultFieldDescriptor();
        stateField.setFieldType("hidden");
        stateField.setName("state");
        stateField.getParameters().put("value", this.state);
        stateField.setType(String.class);
        descriptor.addFieldDescriptor(stateField);
        LinkedList<ActionDescriptor> actionDescriptors = new LinkedList<ActionDescriptor>();
        if (this.transitions.contains((Object)WizardTransition.PREVIOUS)) {
            actionDescriptors.add(new DefaultActionDescriptor("previous"));
        }
        if (this.transitions.contains((Object)WizardTransition.NEXT)) {
            actionDescriptors.add(new DefaultActionDescriptor("next"));
        }
        if (this.transitions.contains((Object)WizardTransition.FINISH)) {
            actionDescriptors.add(new DefaultActionDescriptor("finish"));
        }
        if (this.transitions.contains((Object)WizardTransition.CANCEL)) {
            actionDescriptors.add(new DefaultActionDescriptor("cancel"));
        }
        descriptor.setActionDescriptors(actionDescriptors);
        return descriptor;
    }
}

