/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.form.ui;

import com.zutubi.pulse.form.TextProvider;
import com.zutubi.pulse.form.descriptor.FieldDescriptor;
import com.zutubi.pulse.form.descriptor.FormDescriptor;

public class PropertiesFormDecorator {
    private TextProvider textProvider;

    public PropertiesFormDecorator(TextProvider textProvider) {
        this.textProvider = textProvider;
    }

    public FormDescriptor decorate(FormDescriptor descriptor) {
        this.handleHeader(descriptor);
        for (FieldDescriptor field : descriptor.getFieldDescriptors()) {
            this.handleInlineHelp(field);
        }
        return descriptor;
    }

    private void handleInlineHelp(FieldDescriptor field) {
        String inlineHelpKey;
        String message;
        if (!field.getParameters().containsKey("inlinehelp") && (message = this.textProvider.getText(inlineHelpKey = field.getName() + ".inlinehelp")) != null) {
            field.getParameters().put("inlinehelp", message);
        }
    }

    private void handleHeader(FormDescriptor descriptor) {
        String key;
        String msg;
        if (!descriptor.getParameters().containsKey("heading") && (msg = this.textProvider.getText(key = descriptor.getName() + ".heading")) != null) {
            descriptor.getParameters().put("heading", msg);
        }
    }
}

