/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.form.ui;

import com.opensymphony.util.TextUtils;
import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.zutubi.pulse.form.TextProvider;
import com.zutubi.pulse.form.descriptor.DescriptorFactory;
import com.zutubi.pulse.form.descriptor.FieldDescriptor;
import com.zutubi.pulse.form.descriptor.FormDescriptor;
import com.zutubi.pulse.form.squeezer.SqueezeException;
import com.zutubi.pulse.form.squeezer.Squeezers;
import com.zutubi.pulse.form.squeezer.TypeSqueezer;
import com.zutubi.pulse.form.ui.ComponentRenderer;
import com.zutubi.pulse.form.ui.FormFactory;
import com.zutubi.pulse.form.ui.PropertiesFormDecorator;
import com.zutubi.pulse.form.ui.RenderContext;
import com.zutubi.pulse.form.ui.WizardDecorator;
import com.zutubi.pulse.form.ui.components.Form;
import com.zutubi.pulse.form.ui.renderers.FreemarkerTemplateRenderer;
import com.zutubi.pulse.wizard.Wizard;
import freemarker.template.Configuration;
import java.io.StringWriter;
import java.util.Map;
import ognl.NoSuchPropertyException;
import ognl.Ognl;
import ognl.OgnlException;

public class FormSupport {
    private Configuration configuration;
    private DescriptorFactory descriptorFactory;
    private TextProvider textProvider;
    private String theme;

    public String renderForm(Object obj) throws Exception {
        FormDescriptor descriptor = this.descriptorFactory.createFormDescriptor(obj.getClass());
        return this.renderDescriptor(descriptor, obj);
    }

    public String renderWizard(Wizard wizard, Object obj) throws Exception {
        FormDescriptor descriptor = this.descriptorFactory.createFormDescriptor(obj.getClass());
        WizardDecorator decorator = new WizardDecorator(wizard);
        descriptor = decorator.decorate(descriptor);
        return this.renderDescriptor(descriptor, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String renderDescriptor(FormDescriptor descriptor, Object obj) throws Exception {
        PropertiesFormDecorator decorator = new PropertiesFormDecorator(this.textProvider);
        descriptor = decorator.decorate(descriptor);
        Form form = new FormFactory().createForm(descriptor, obj);
        StringWriter writer = new StringWriter();
        FreemarkerTemplateRenderer templateRenderer = new FreemarkerTemplateRenderer();
        templateRenderer.setConfiguration(this.configuration);
        if (TextUtils.stringSet((String)this.theme)) {
            templateRenderer.setTheme(this.theme);
        }
        RenderContext context = new RenderContext(templateRenderer, this.textProvider);
        context.setWriter(writer);
        ComponentRenderer renderer = new ComponentRenderer();
        renderer.setContext(context);
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        try {
            stack.push(obj);
            renderer.render(form);
        }
        finally {
            stack.pop();
        }
        writer.flush();
        return writer.toString();
    }

    public void populateObject(Object obj) {
        FormDescriptor formDescriptor = this.descriptorFactory.createFormDescriptor(obj.getClass());
        for (FieldDescriptor fieldDescriptor : formDescriptor.getFieldDescriptors()) {
            String name = fieldDescriptor.getName();
            TypeSqueezer squeezer = Squeezers.findSqueezer(fieldDescriptor.getType());
            String[] paramValue = this.getParameterValue(name);
            if (paramValue == null) continue;
            try {
                Object value = squeezer.unsqueeze(paramValue);
                Ognl.setValue((String)name, (Object)obj, (Object)value);
            }
            catch (NoSuchPropertyException e) {
            }
            catch (OgnlException e) {
                e.printStackTrace();
            }
            catch (SqueezeException e) {
                e.printStackTrace();
            }
        }
    }

    private String[] getParameterValue(String parameterName) {
        Map parameters = ActionContext.getContext().getParameters();
        if (!parameters.containsKey(parameterName)) {
            return null;
        }
        Object parameterValue = parameters.get(parameterName);
        if (parameterValue instanceof String) {
            return new String[]{(String)parameterValue};
        }
        if (parameterValue instanceof String[]) {
            return (String[])parameterValue;
        }
        return null;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public void setDescriptorFactory(DescriptorFactory descriptorFactory) {
        this.descriptorFactory = descriptorFactory;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setTextProvider(TextProvider textProvider) {
        this.textProvider = textProvider;
    }
}

