/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.form.squeezer;

import com.zutubi.pulse.form.squeezer.TypeSqueezer;
import com.zutubi.pulse.form.squeezer.squeezers.BooleanSqueezer;
import com.zutubi.pulse.form.squeezer.squeezers.DoubleSqueezer;
import com.zutubi.pulse.form.squeezer.squeezers.FloatSqueezer;
import com.zutubi.pulse.form.squeezer.squeezers.IntegerSqueezer;
import com.zutubi.pulse.form.squeezer.squeezers.LongSqueezer;
import com.zutubi.pulse.form.squeezer.squeezers.ShortSqueezer;
import com.zutubi.pulse.form.squeezer.squeezers.StringSqueezer;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Squeezers {
    private static final Map<Class, Class<? extends TypeSqueezer>> registry = new HashMap<Class, Class<? extends TypeSqueezer>>();

    public static TypeSqueezer findSqueezer(Class type) {
        if (registry.containsKey(type)) {
            try {
                return registry.get(type).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static void register(Class type, Class<? extends TypeSqueezer> squeezer) {
        registry.put(type, squeezer);
    }

    public static void unregister(Class type) {
        registry.remove(type);
    }

    static {
        Squeezers.register(String.class, StringSqueezer.class);
        Squeezers.register(Boolean.class, BooleanSqueezer.class);
        Squeezers.register(Boolean.TYPE, BooleanSqueezer.class);
        Squeezers.register(Integer.class, IntegerSqueezer.class);
        Squeezers.register(Integer.TYPE, IntegerSqueezer.class);
        Squeezers.register(Long.class, LongSqueezer.class);
        Squeezers.register(Long.TYPE, LongSqueezer.class);
        Squeezers.register(Double.class, DoubleSqueezer.class);
        Squeezers.register(Double.TYPE, DoubleSqueezer.class);
        Squeezers.register(Short.class, ShortSqueezer.class);
        Squeezers.register(Short.TYPE, ShortSqueezer.class);
        Squeezers.register(Float.class, FloatSqueezer.class);
        Squeezers.register(Float.TYPE, FloatSqueezer.class);
    }
}

