/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.form.persistence.stores;

import com.zutubi.pulse.form.persistence.Copyable;
import com.zutubi.pulse.form.persistence.ObjectRegistry;
import com.zutubi.pulse.form.persistence.ObjectStore;
import java.util.HashMap;
import java.util.Map;

public class MemoryObjectStore
implements ObjectStore {
    private ObjectRegistry registry;
    private Map<String, Copyable> instances = new HashMap<String, Copyable>();

    public Copyable reset(String key) {
        this.instances.put(key, (Copyable)this.createInstance(key));
        return this.instances.get(key).copy();
    }

    public Copyable load(String key) {
        if (!this.instances.containsKey(key)) {
            this.instances.put(key, (Copyable)this.createInstance(key));
        }
        return this.instances.get(key).copy();
    }

    public void save(String key, Copyable obj) {
        this.instances.put(key, obj.copy());
    }

    private Object createInstance(String key) {
        Class cls = this.registry.findType(key);
        try {
            return cls.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setObjectRegistry(ObjectRegistry registry) {
        this.registry = registry;
    }
}

