/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.form.persist.file;

import com.zutubi.pulse.form.persist.ObjectNotFoundException;
import com.zutubi.pulse.form.persist.PersistenceException;
import com.zutubi.pulse.form.persist.file.FileObjectStore;
import com.zutubi.pulse.form.persist.file.mock.MockBook;
import com.zutubi.pulse.form.persist.file.mock.MockBookWithId;
import com.zutubi.pulse.form.persist.file.mock.MockIdField;
import com.zutubi.pulse.form.persist.file.mock.MockNoIdField;
import com.zutubi.pulse.form.persist.reflection.ReflectionDescriptorFactory;
import com.zutubi.pulse.test.PulseTestCase;
import com.zutubi.pulse.util.FileSystemUtils;
import java.io.File;

public class FileObjectStoreTest
extends PulseTestCase {
    private FileObjectStore objectStore;
    private File baseDir = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.baseDir = FileSystemUtils.createTempDir((String)((Object)((Object)this)).getClass().getName(), (String)".tmp");
        this.objectStore = new FileObjectStore();
        this.objectStore.setBaseDir(this.baseDir);
        this.objectStore.setDescriptorFactory(new ReflectionDescriptorFactory());
    }

    protected void tearDown() throws Exception {
        this.removeDirectory(this.baseDir);
        super.tearDown();
    }

    public void testHasId() {
        FileObjectStoreTest.assertTrue((boolean)this.objectStore.hasId(MockIdField.class));
        FileObjectStoreTest.assertFalse((boolean)this.objectStore.hasId(MockNoIdField.class));
    }

    public void testGenerateId() throws PersistenceException {
        FileObjectStoreTest.assertEquals((Object)1L, (Object)this.objectStore.generateId(MockIdField.class));
        FileObjectStoreTest.assertEquals((Object)1L, (Object)this.objectStore.generateId(MockNoIdField.class));
    }

    public void testSave() throws PersistenceException {
        MockBook mockBook = new MockBook();
        mockBook.setTitle("Book Title");
        mockBook.setPageCount(1234321);
        this.objectStore.save(Long.valueOf(1L), mockBook);
        MockBook persistedBook = (MockBook)this.objectStore.load(MockBook.class, Long.valueOf(1L));
        FileObjectStoreTest.assertEquals((String)"Book Title", (String)persistedBook.getTitle());
        FileObjectStoreTest.assertEquals((int)1234321, (int)persistedBook.getPageCount());
    }

    public void testSaveWithId() throws PersistenceException {
        MockBookWithId mockBook = new MockBookWithId();
        mockBook.setTitle("Book Title");
        this.objectStore.save(mockBook);
        FileObjectStoreTest.assertEquals((long)1L, (long)mockBook.getId());
        MockBookWithId persistentBook = (MockBookWithId)this.objectStore.load(MockBookWithId.class, Long.valueOf(mockBook.getId()));
        FileObjectStoreTest.assertEquals((String)"Book Title", (String)persistentBook.getTitle());
    }

    public void testSaveOrUpdateWithId() throws PersistenceException {
        MockBookWithId mockBook = new MockBookWithId();
        mockBook.setTitle("Book Title");
        this.objectStore.saveOrUpdate(mockBook);
        FileObjectStoreTest.assertEquals((long)1L, (long)mockBook.getId());
        mockBook.setTitle("Updated Title");
        this.objectStore.saveOrUpdate(mockBook);
        FileObjectStoreTest.assertEquals((long)1L, (long)mockBook.getId());
        MockBookWithId persistentBook = (MockBookWithId)this.objectStore.load(MockBookWithId.class, Long.valueOf(mockBook.getId()));
        FileObjectStoreTest.assertEquals((String)"Updated Title", (String)persistentBook.getTitle());
    }

    public void testUpdate() throws PersistenceException {
        MockBook mockBook = new MockBook();
        mockBook.setTitle("Book Title");
        mockBook.setPageCount(1234321);
        this.objectStore.save(Long.valueOf(1L), mockBook);
        mockBook.setTitle("Updated Book Title");
        this.objectStore.update(Long.valueOf(1L), mockBook);
        MockBook persistedBook = (MockBook)this.objectStore.load(MockBook.class, Long.valueOf(1L));
        FileObjectStoreTest.assertEquals((String)"Updated Book Title", (String)persistedBook.getTitle());
        FileObjectStoreTest.assertEquals((int)1234321, (int)persistedBook.getPageCount());
    }

    public void testSaveUsingExistingIdThrowsException() throws PersistenceException {
        MockBook mockBook = new MockBook();
        mockBook.setTitle("Book Title");
        mockBook.setPageCount(1234321);
        this.objectStore.save(Long.valueOf(1L), mockBook);
        try {
            this.objectStore.save(Long.valueOf(1L), mockBook);
            FileObjectStoreTest.fail();
        }
        catch (PersistenceException persistenceException) {
            // empty catch block
        }
    }

    public void testDelete() throws PersistenceException {
        MockBook mockBook = new MockBook();
        mockBook.setTitle("Book Title");
        mockBook.setPageCount(1234321);
        this.objectStore.save(Long.valueOf(1L), mockBook);
        this.objectStore.delete(Long.valueOf(1L), MockBook.class);
        try {
            this.objectStore.load(MockBook.class, Long.valueOf(1L));
            FileObjectStoreTest.fail();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    public void testDeleteWithId() throws PersistenceException {
        MockBookWithId mockBook = new MockBookWithId();
        mockBook.setTitle("Book Title");
        this.objectStore.save(mockBook);
        this.objectStore.delete(mockBook);
        try {
            this.objectStore.load(MockBook.class, Long.valueOf(mockBook.getId()));
            FileObjectStoreTest.fail();
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            // empty catch block
        }
    }

    public void testDeletingNonExistantObject() throws PersistenceException {
        this.objectStore.delete(Long.valueOf(1L), MockBook.class);
    }
}

