/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.form.persist.file;

import com.thoughtworks.xstream.XStream;
import com.zutubi.pulse.form.persist.DescriptorFactory;
import com.zutubi.pulse.form.persist.KeyGenerator;
import com.zutubi.pulse.form.persist.ObjectNotFoundException;
import com.zutubi.pulse.form.persist.ObjectStore;
import com.zutubi.pulse.form.persist.PersistenceDescriptor;
import com.zutubi.pulse.form.persist.PersistenceException;
import com.zutubi.pulse.form.persist.file.FileKeyGenerator;
import com.zutubi.pulse.util.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;

public class FileObjectStore
implements ObjectStore {
    private File baseDir;
    private KeyGenerator keyGenerator;
    private DescriptorFactory descriptorFactory;

    public Object load(Class clazz, Serializable id) throws PersistenceException {
        return this.readFromStorage(id, clazz);
    }

    public void save(Object obj) throws PersistenceException {
        this.verifyIdAvailable(obj);
        Serializable id = this.generateId(obj.getClass());
        this.setId(id, obj);
        this.save(id, obj);
    }

    public void saveOrUpdate(Object obj) throws PersistenceException {
        this.verifyIdAvailable(obj);
        if (this.isPersistent(obj)) {
            this.update(obj);
        } else {
            this.save(obj);
        }
    }

    public void update(Object obj) throws PersistenceException {
        this.verifyIdAvailable(obj);
        this.verifyPersistent(obj);
        Serializable id = this.getId(obj);
        this.update(id, obj);
    }

    public boolean delete(Object obj) throws PersistenceException {
        this.verifyIdAvailable(obj);
        this.verifyPersistent(obj);
        Serializable id = this.getId(obj);
        return this.delete(id, obj.getClass());
    }

    private void verifyIdAvailable(Object obj) throws PersistenceException {
        PersistenceDescriptor descriptor = this.descriptorFactory.createDescriptor(obj.getClass());
        if (descriptor.getIdProperty() == null) {
            throw new PersistenceException();
        }
    }

    private boolean isPersistent(Object obj) throws PersistenceException {
        Serializable id = this.getId(obj);
        if (id == null) {
            return false;
        }
        if (id instanceof Number) {
            return ((Number)id).longValue() != 0L;
        }
        return true;
    }

    private void verifyPersistent(Object obj) throws PersistenceException {
        if (!this.isPersistent(obj)) {
            throw new PersistenceException();
        }
    }

    private Serializable getId(Object obj) throws PersistenceException {
        PersistenceDescriptor descriptor = this.descriptorFactory.createDescriptor(obj.getClass());
        try {
            return (Serializable)descriptor.getReaderMethod().invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new PersistenceException();
        }
    }

    private void setId(Serializable id, Object obj) throws PersistenceException {
        PersistenceDescriptor descriptor = this.descriptorFactory.createDescriptor(obj.getClass());
        try {
            descriptor.getWriterMethod().invoke(obj, id);
        }
        catch (Exception e) {
            throw new PersistenceException();
        }
    }

    public void save(Serializable id, Object obj) throws PersistenceException {
        if (this.storageFile(id, obj.getClass()).exists()) {
            throw new PersistenceException();
        }
        this.writeToStorage(id, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToStorage(Serializable id, Object obj) throws PersistenceException {
        File f = this.storageFile(id, obj.getClass());
        if (!f.exists()) {
            this.createStorageFile(f);
        }
        OutputStreamWriter writer = null;
        try {
            XStream xstream = new XStream();
            writer = new OutputStreamWriter(new FileOutputStream(f));
            xstream.toXML(obj, (Writer)writer);
            IOUtils.close((Closeable)writer);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.close(writer);
        }
    }

    private Object readFromStorage(Serializable id, Class clazz) throws ObjectNotFoundException {
        Object object;
        File f = this.storageFile(id, clazz);
        if (!f.isFile()) {
            throw new ObjectNotFoundException();
        }
        InputStreamReader reader = null;
        try {
            XStream xstream = new XStream();
            reader = new InputStreamReader(new FileInputStream(f));
            object = xstream.fromXML((Reader)reader);
        }
        catch (FileNotFoundException e) {
            try {
                e.printStackTrace();
                throw new ObjectNotFoundException();
            }
            catch (Throwable throwable) {
                IOUtils.close(reader);
                throw throwable;
            }
        }
        IOUtils.close((Closeable)reader);
        return object;
    }

    public void update(Serializable id, Object obj) throws PersistenceException {
        this.writeToStorage(id, obj);
    }

    public boolean delete(Serializable id, Class clazz) throws PersistenceException {
        File f = this.storageFile(id, clazz);
        if (!f.isFile()) {
            return false;
        }
        if (!f.delete()) {
            throw new PersistenceException("Failed to delete.");
        }
        return true;
    }

    public boolean hasId(Class clazz) {
        PersistenceDescriptor descriptor = this.descriptorFactory.createDescriptor(clazz);
        return descriptor.getIdProperty() != null;
    }

    public Serializable generateId(Class clazz) throws PersistenceException {
        return this.keyGenerator.generate(clazz);
    }

    private void createStorageFile(File f) throws PersistenceException {
        if (f.isFile()) {
            return;
        }
        if (f.exists()) {
            throw new PersistenceException();
        }
        if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
            throw new PersistenceException();
        }
        try {
            if (!f.createNewFile()) {
                throw new PersistenceException();
            }
        }
        catch (IOException e) {
            throw new PersistenceException(e);
        }
    }

    private File storageFile(Serializable id, Class type) {
        return new File(this.baseDir, type.getName() + "/" + id + ".xml");
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
        this.keyGenerator = new FileKeyGenerator(this.baseDir);
    }

    public void setDescriptorFactory(DescriptorFactory descriptorFactory) {
        this.descriptorFactory = descriptorFactory;
    }
}

