/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.form.descriptor.reflection;

import com.zutubi.pulse.form.descriptor.DefaultFieldDescriptor;
import com.zutubi.pulse.form.descriptor.DefaultFormDescriptor;
import com.zutubi.pulse.form.descriptor.DescriptorDecorator;
import com.zutubi.pulse.form.descriptor.DescriptorFactory;
import com.zutubi.pulse.form.descriptor.FieldDescriptor;
import com.zutubi.pulse.form.descriptor.FormDescriptor;
import com.zutubi.pulse.form.descriptor.reflection.ReflectionException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionDescriptorFactory
implements DescriptorFactory {
    private static final Map<Class, String> defaultFieldTypeMapping = new HashMap<Class, String>();
    private final Map<Class, FormDescriptor> formDescriptorCache = new HashMap<Class, FormDescriptor>();
    private List<DescriptorDecorator> decorators = new LinkedList<DescriptorDecorator>();

    @Override
    public FormDescriptor createFormDescriptor(Class type) {
        DefaultFormDescriptor formDescriptor = new DefaultFormDescriptor();
        formDescriptor.setType(type);
        formDescriptor.setName(type.getSimpleName());
        formDescriptor.setFieldDescriptors(this.buildFieldDescriptors(type));
        return this.applyDecorators(formDescriptor);
    }

    private FormDescriptor applyDecorators(FormDescriptor formDescriptor) {
        for (DescriptorDecorator decorator : this.decorators) {
            formDescriptor = decorator.decorate(formDescriptor);
        }
        return formDescriptor;
    }

    @Override
    public void setDecorators(List<DescriptorDecorator> decorators) {
        this.decorators = decorators;
    }

    public void addDecorator(DescriptorDecorator decorator) {
        this.decorators.add(decorator);
    }

    private List<FieldDescriptor> buildFieldDescriptors(Class type) {
        try {
            LinkedList<FieldDescriptor> fieldDescriptors = new LinkedList<FieldDescriptor>();
            BeanInfo beanInfo = Introspector.getBeanInfo(type, Object.class);
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                DefaultFieldDescriptor fd = new DefaultFieldDescriptor();
                fd.setName(pd.getName());
                if (pd.getPropertyType() == Boolean.TYPE) {
                    fd.setType(Boolean.class);
                } else {
                    fd.setType(pd.getPropertyType());
                }
                if (fd.getName().equals("password")) {
                    fd.setFieldType("password");
                } else {
                    fd.setFieldType(defaultFieldTypeMapping.get(pd.getPropertyType()));
                }
                fieldDescriptors.add(fd);
            }
            HashMap<String, FieldDescriptor> optionsCandidates = new HashMap<String, FieldDescriptor>();
            HashMap<String, FieldDescriptor> descriptorMap = new HashMap<String, FieldDescriptor>();
            for (FieldDescriptor fd : fieldDescriptors) {
                String name = fd.getName();
                if (name.endsWith("Options")) {
                    String property = name.substring(0, name.length() - 7);
                    optionsCandidates.put(property, fd);
                }
                descriptorMap.put(name, fd);
            }
            for (String candidate : optionsCandidates.keySet()) {
                if (!descriptorMap.containsKey(candidate)) continue;
                FieldDescriptor optionsDescriptor = (FieldDescriptor)optionsCandidates.get(candidate);
                fieldDescriptors.remove(optionsDescriptor);
                FieldDescriptor optionDescriptor = (FieldDescriptor)descriptorMap.get(candidate);
                optionDescriptor.setFieldType("select");
            }
            return fieldDescriptors;
        }
        catch (IntrospectionException e) {
            throw new ReflectionException(e);
        }
    }

    static {
        defaultFieldTypeMapping.put(String.class, "text");
        defaultFieldTypeMapping.put(Boolean.class, "checkbox");
        defaultFieldTypeMapping.put(Boolean.TYPE, "checkbox");
    }
}

